"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _reactCore = require("@patternfly/react-core");

var _Icons = _interopRequireDefault(require("../../Icons"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PatternFlyDropDown extends React.PureComponent {
  renderDropDownItems(actions) {
    const renderItems = [];
    actions.forEach(item => {
      if (item.hasDivider) {
        renderItems.push(React.createElement(_reactCore.DropdownSeparator, {
          key: "separator"
        }));
      }

      renderItems.push(React.createElement(_reactCore.DropdownItem, {
        key: "action",
        component: "button",
        onClick: () => setTimeout(() => item.handler()),
        "data-mode": item.label
      }, React.createElement("span", {
        className: "small-right-pad",
        style: !item.isSelected ? {
          opacity: 0
        } : undefined
      }, React.createElement(_Icons.default, {
        icon: "Checkmark",
        "data-mode": "selected container"
      })), item.label));
    });
    return renderItems;
  }

  render() {
    if (this.props.actions.length === 0) {
      return React.createElement(React.Fragment, null);
    }

    return React.createElement(_reactCore.Dropdown, {
      className: this.props.className,
      onSelect: () => {
        this.setState(curState => ({
          isOpen: !curState.isOpen
        }));

        if (this.props.onClose) {
          this.props.onClose();
        }
      },
      toggle: React.createElement(_reactCore.KebabToggle, {
        onToggle: isOpen => {
          this.setState({
            isOpen
          });
        }
      }),
      isOpen: this.state && this.state.isOpen,
      isPlain: true,
      dropdownItems: this.renderDropDownItems(this.props.actions),
      position: "right"
    });
  }

}

exports.default = PatternFlyDropDown;