"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _carbonComponentsReact = require("carbon-components-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('client', 'about');

class CarbonSideNav extends React.PureComponent {
  /** render menu options specified by client/config.d/about.json */
  renderSideNavMenu(menuIdx) {
    const thisNav = this.props.current.allNavs[menuIdx];
    return React.createElement(_carbonComponentsReact.SideNavMenu, {
      title: strings(thisNav.title),
      key: menuIdx,
      isActive: true,
      defaultExpanded: true,
      className: menuIdx === 0 ? 'sidecar-header-name-content' : undefined
    }, thisNav.tabs.map((mode, idx) => React.createElement(_carbonComponentsReact.SideNavMenuItem, {
      href: "#" // needed for tab navigation
      ,
      key: idx,
      "data-mode": mode.mode,
      isActive: this.props.current.current.menuIdx === menuIdx && this.props.current.current.tabIdx === idx,
      onClick: () => this.props.changeCurrent(menuIdx, idx),
      onMouseDown: event => event.preventDefault()
    }, React.createElement("span", {
      className: "kui--mode-placeholder",
      "data-mode": mode.mode
    }, strings(mode.label || mode.mode)))));
  }

  renderSideNavLink(idx, link) {
    if ((0, _core.isLinkWithCommand)(link)) {
      return React.createElement(_carbonComponentsReact.SideNavLink, {
        className: "kui--nav-command-link",
        "data-link": strings(link.label),
        key: idx,
        href: "#",
        onClick: () => this.props.tab.REPL.pexec(link.command)
      }, strings(link.label));
    } else {
      return React.createElement(_carbonComponentsReact.SideNavLink, {
        className: "kui--nav-href-link",
        "data-link": strings(link.label),
        key: idx,
        target: "_blank",
        href: link.href
      }, strings(link.label));
    }
  }

  render() {
    return React.createElement(_carbonComponentsReact.SideNav, {
      "aria-label": "Side navigation",
      expanded: true,
      isChildOfHeader: false,
      isFixedNav: true
    }, React.createElement(_carbonComponentsReact.SideNavItems, null, this.props.current.allNavs.map((nav, idx) => this.renderSideNavMenu(idx)), this.props.current.allLinks.map((link, idx) => this.renderSideNavLink(idx, link))));
  }

}

exports.default = CarbonSideNav;