"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _uuid = require("uuid");

var _core = require("@kui-shell/core");

var _carbonComponentsReact = require("carbon-components-react");

var _Icons = _interopRequireDefault(require("../../Icons"));

var _index = require("../index");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

class CarbonRadioTable extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      uuid: (0, _uuid.v4)()
    };
  }

  onChange(selectedIdx, onSelect) {
    return __awaiter(this, void 0, void 0, function* () {
      // wow, carbon components isn't so great; we have to manage unchecking ourselves??
      const currentSelection = document.getElementById(this.id(this.props.selectedIdx));

      if (currentSelection) {
        currentSelection.checked = false;
      }

      if (onSelect) {
        yield onSelect();
      }

      this.props.onChange(selectedIdx + this.props.offset);
    });
  }

  id(idx) {
    return `${this.state.uuid}-${idx}`;
  }

  row(row, ridx, head, onSelect) {
    const isSelected = !head && ridx === this.props.selectedIdx - this.props.offset;
    const name = this.id(ridx); // notes: label is needed for selection

    return React.createElement(_carbonComponentsReact.StructuredListRow, {
      label: true,
      head: head,
      key: ridx,
      "data-name": row.nameIdx !== undefined ? (0, _core.radioTableCellToString)(row.cells[row.nameIdx]) : name,
      "data-is-selected": isSelected || undefined
    }, !head && React.createElement(_carbonComponentsReact.StructuredListInput, {
      defaultChecked: isSelected,
      id: name,
      name: name,
      value: name,
      onChange: this.onChange.bind(this, ridx, onSelect)
    }), React.createElement(_carbonComponentsReact.StructuredListCell, null, !head && React.createElement(_Icons.default, {
      icon: "Checkmark",
      className: "bx--structured-list-svg"
    })), row.cells.map((cell, cidx) => {
      const badgeHint = (0, _core.cellShouldHaveBadge)(cell);
      return React.createElement(_carbonComponentsReact.StructuredListCell, {
        head: head,
        key: cidx,
        "data-is-name": cidx === row.nameIdx ? true : undefined,
        "data-key": typeof cell !== 'string' ? cell.key : undefined,
        className: (0, _core.radioTableHintsAsCss)(cell)
      }, React.createElement("span", {
        "data-tag": badgeHint ? 'badge' : undefined
      }, badgeHint && React.createElement("span", {
        "data-tag": "badge-circle",
        className: badgeHint.toString()
      }), React.createElement("span", {
        className: "kui--cell-inner-text"
      }, (0, _core.radioTableCellToString)(cell))));
    }));
  }

  header() {
    return React.createElement(_carbonComponentsReact.StructuredListHead, null, this.row(this.props.table.header, 0, true));
  }

  body() {
    return React.createElement(_carbonComponentsReact.StructuredListBody, null, (0, _index.slice)(this.props).map((row, idx) => this.row(row, idx, false, row.onSelect)));
  }

  render() {
    return React.createElement(_carbonComponentsReact.StructuredListWrapper, {
      selection: true,
      className: "kui--radio-table kui--table-like"
    }, this.header(), this.body());
  }

}

exports.default = CarbonRadioTable;