/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { pexecInCurrentTab } from '@kui-shell/core';
export default class TextWithIconWidget extends React.PureComponent {
    render() {
        const iconClassName = 'kui--status-stripe-icon ' +
            (this.props.iconIsNarrow ? 'tiny-right-pad' : 'small-right-pad') +
            (this.props.iconOnclick ? ' clickable' : '');
        const iconPart = this.props.iconOnclick ? (React.createElement("a", { href: "#", className: iconClassName, onMouseDown: evt => evt.preventDefault(), onClick: !this.props.iconOnclick
                ? undefined
                : (evt) => {
                    evt.stopPropagation();
                    if (typeof this.props.iconOnclick === 'string') {
                        pexecInCurrentTab(this.props.iconOnclick);
                    }
                    else {
                        this.props.iconOnclick();
                    }
                } }, this.props.children)) : (React.createElement("span", { className: iconClassName }, this.props.children));
        const textPart = React.createElement("span", { className: "kui--status-stripe-text" }, this.props.text);
        return (React.createElement("div", { className: 'kui--status-stripe-element' +
                (this.props.textOnclick ? ' kui--status-stripe-element-clickable' : '') +
                (!this.props.id ? '' : ' ' + this.props.id) +
                (this.props.className ? ' ' + this.props.className : ''), title: this.props.title, "data-view": this.props.viewLevel, onClick: !this.props.textOnclick
                ? undefined
                : () => {
                    if (typeof this.props.textOnclick === 'string') {
                        pexecInCurrentTab(this.props.textOnclick);
                    }
                    else {
                        this.props.textOnclick();
                    }
                } },
            iconPart,
            textPart));
    }
}
//# sourceMappingURL=TextWithIconWidget.js.map