/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME:
/* eslint-disable react/prop-types */
import * as React from 'react';
import { pexecInCurrentTab, i18n } from '@kui-shell/core';
import Icons from '../../spi/Icons';
const strings = i18n('plugin-client-common');
export default class StatusStripe extends React.PureComponent {
    /**
     * User has clicked on the Settings icon.
     *
     */
    doAbout() {
        return __awaiter(this, void 0, void 0, function* () {
            pexecInCurrentTab('about');
        });
    }
    /**
     * If the Client offers no status stripe widgets, we should insert a
     * filler, so that the Settings icon is presented flush-right.
     *
     */
    filler() {
        return React.createElement("div", { style: { flex: 1 } });
    }
    /**
     * Render any widgets specified by the client.
     *
     */
    widgets() {
        if (React.Children.count(this.props.children) === 0) {
            return this.filler();
        }
        else {
            return this.props.children;
        }
    }
    render() {
        return (React.createElement("div", { className: "kui--status-stripe kui--inverted-color-context zoomable", id: "kui--status-stripe" },
            this.widgets(),
            React.createElement("div", { className: "kui--status-stripe-button" },
                React.createElement("a", { href: "#", className: "kui--tab-navigatable kui--status-stripe-element-clickable kui--status-stripe-element", id: "help-button", "aria-label": "Help", tabIndex: 0, title: strings('Click to view configuration options'), onClick: () => this.doAbout() },
                    React.createElement(Icons, { icon: "Settings" })))));
    }
}
//# sourceMappingURL=index.js.map