import SplitPane from 'react-split-pane';
import * as React from 'react';
import { Tab as KuiTab, TabState } from '@kui-shell/core';
import { TopTabButton } from './TabModel';
import Width from '../Views/Sidecar/width';
import { Height } from '../Views/WatchPane';
import { TerminalOptions } from '../Views/Terminal/ScrollableTerminal';
import '../../../web/css/static/split-pane.scss';
interface WithTabUUID {
    uuid: string;
}
interface WithTab {
    tab: KuiTab;
    tabClassList: Record<string, boolean>;
}
export declare type TabContentOptions = TerminalOptions & {
    /** [Optional] elements to be placed below the Terminal */
    bottom?: React.ReactElement<WithTabUUID & WithTab>;
};
declare type Props = TabContentOptions & WithTabUUID & {
    active: boolean;
    state: TabState;
    onTabReady?: (tab: KuiTab) => void;
    willUpdateTopTabButtons?: (buttons: TopTabButton[]) => void;
};
declare type CurrentlyShowing = 'TerminalOnly' | 'TerminalPlusSidecar' | 'TerminalPlusWatcher' | 'TerminalSidecarWatcher';
declare type SessionInitStatus = 'NotYet' | 'InProgress' | 'Reinit' | 'Done' | 'Error';
declare type State = Partial<WithTab> & {
    sessionInit: SessionInitStatus;
    sessionInitError?: Error;
    showSessionInitDone: boolean;
    sidecarWidth: Width;
    priorSidecarWidth: Width;
    sidecarHasContent: boolean;
    primaryHeight: Height;
    watchPaneHasContent: boolean;
    splitPaneImpl?: SplitPane;
    splitPaneImplHacked?: boolean;
    activeView: CurrentlyShowing;
};
/**
 *
 * TabContent
 * ----------------  <Tab/> from here down
 * | ST  |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * ----------------
 *  ST: <ScrollableTerminal/>
 *
 */
export default class TabContent extends React.PureComponent<Props, State> {
    private readonly cleaners;
    /** switching back or away from this tab */
    private activateHandlers;
    /** grab a ref (below) so that we can maintain focus */
    private _terminal;
    constructor(props: Props);
    componentDidMount(): void;
    private onOffline;
    private static onSessionInitError;
    /** emit /tab/new event, if we have now a tab, but have not yet
     * emitted the event */
    static getDerivedStateFromProps(props: Props, state: State): State | {
        sessionInit: string;
    };
    /** Hmm, SplitPane doesn't yet allow for styling of the Resizer */
    private static hackResizer;
    componentWillUnmount(): void;
    private defaultLoading;
    private terminal;
    private onWillChangeSize;
    private show;
    /** Switch to the given view, if we aren't already there */
    private showIfNot;
    private openWatchPane;
    private closeWatchPane;
    private onWillLoseFocus;
    private graft;
    /** Graft on the REPL focus management */
    private children;
    /** Graft on the tab uuid */
    private bottom;
    /** Construct the `className` property of the tab element */
    private tabClassName;
    render(): JSX.Element;
    /**
     *  Terminal | Sidecar
     *  ------------------
     *      WatchPane
     */
    private topDownSplit;
    /**
     * [ Terminal | Sidecar ]
     */
    private leftRightSplit;
    /**
     * If given, use the top tab button controller to provide the
     * latest button model.
     *
     */
    private updateTopTabButtons;
    /**
     * Note how we use the argument `state` to initialize things, but we
     * intentionally use this.state in the onClick. The onClick handler
     * may be invoked after any number of onClicks in this or other
     * buttons. So it must pay attention to the *current* state, not the
     * state at the time of creation.
     *
     */
    private terminalButton;
    /** Caution: see the Note for this.terminalButton, re: `state` versus `this.state` */
    private sidecarButton;
}
export {};
