import * as React from 'react';
import { Tab as KuiTab, Stream, Streamable } from '@kui-shell/core';
import { BlockViewTraits } from './';
import { ProcessingBlock, FinishedBlock } from './BlockModel';
declare type Props = {
    /** tab UUID */
    uuid: string;
    /** for key handlers, which may go away soon */
    tab: KuiTab;
    model: ProcessingBlock | FinishedBlock;
    onRender: () => void;
} & BlockViewTraits;
interface State {
    assertHasContent?: boolean;
    isResultRendered: boolean;
    streamingOutput: Streamable[];
    streamingConsumer: Stream;
}
export default class Output extends React.PureComponent<Props, State> {
    constructor(props: Props);
    private streamingConsumer;
    static getDerivedStateFromProps(props: Props, state: State): State | {
        isResultRendered: boolean;
        streamingConsumer: any;
    };
    private onRender;
    private stream;
    private result;
    private cursor;
    private isShowingSomethingInTerminal;
    private ok;
    render(): JSX.Element;
}
export {};
