/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { Brand, Card, CardActions, CardBody, CardFooter, CardHeader, CardHeaderMain, CardTitle, Dropdown, DropdownItem, KebabToggle } from '@patternfly/react-core';
import Markdown from '../../../Content/Markdown';
import '../../../../../web/scss/components/Card/PatternFly.scss';
export default class PatternflyCard extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            isOpen: false
        };
    }
    renderDropDownItems(actions) {
        return actions.map((item, idx) => (React.createElement(DropdownItem, { key: idx, component: "button", onClick: item.handler, "data-mode": item.label }, item.label)));
    }
    cardActions() {
        return (React.createElement(CardActions, null,
            this.props.inlineActions,
            this.props.actions && React.createElement(Dropdown, { onSelect: () => this.setState({ isOpen: !this.state.isOpen }), toggle: React.createElement(KebabToggle, { onToggle: isOpen => {
                        this.setState({ isOpen });
                    } }), isOpen: this.state.isOpen, isPlain: true, dropdownItems: this.renderDropDownItems(this.props.actions), position: 'right' })));
    }
    icon() {
        return React.createElement(Brand, { src: this.props.icon, alt: "card icon", className: "kui--card-icon" });
    }
    /** card actions, icon and custom header node will be situated in Card Head */
    header() {
        return ((this.props.header || this.props.icon || this.props.titleInHeader || this.props.bodyInHeader || this.props.inlineActions || this.props.actions) && (React.createElement(CardHeader, { className: "kui--card-header" },
            React.createElement(CardHeaderMain, null, this.props.header || (this.props.icon && this.icon())),
            (this.props.inlineActions || this.props.actions) && this.cardActions(),
            React.createElement("div", null,
                this.props.titleInHeader && this.title(),
                this.props.bodyInHeader && this.body()))));
    }
    /** card footer */
    footer() {
        return this.props.footer && React.createElement(CardFooter, { className: "kui--card-footer" }, this.props.footer);
    }
    title() {
        if (this.props.title) {
            return React.createElement(CardTitle, null,
                " ",
                this.props.title,
                " ");
        }
    }
    body() {
        if (Array.isArray(this.props.children)) {
            return this.props.children.map((child, idx) => (React.createElement(CardBody, { className: "kui--card-body", key: idx }, child)));
        }
        else {
            return (React.createElement(CardBody, { className: "kui--card-body" }, typeof this.props.children === 'string' ? (React.createElement(Markdown, { source: this.props.children, repl: this.props.repl })) : (this.props.children)));
        }
    }
    render() {
        const basicClassName = 'kui--card small-top-pad small-bottom-pad';
        return (React.createElement(Card, { isCompact: true, className: !this.props.className ? basicClassName : `${basicClassName} ${this.props.className}` }, React.Children.count(this.props.children) > 0 && (React.createElement(React.Fragment, null,
            this.header(),
            !this.props.titleInHeader && this.title(),
            !this.props.bodyInHeader && this.body(),
            this.footer()))));
    }
}
//# sourceMappingURL=PatternFly.js.map