import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Button/button';
import { css } from '@patternfly/react-styles';
import { getOUIAProps } from '../../helpers';
export var ButtonVariant;
(function (ButtonVariant) {
    ButtonVariant["primary"] = "primary";
    ButtonVariant["secondary"] = "secondary";
    ButtonVariant["tertiary"] = "tertiary";
    ButtonVariant["danger"] = "danger";
    ButtonVariant["link"] = "link";
    ButtonVariant["plain"] = "plain";
    ButtonVariant["control"] = "control";
})(ButtonVariant || (ButtonVariant = {}));
export var ButtonType;
(function (ButtonType) {
    ButtonType["button"] = "button";
    ButtonType["submit"] = "submit";
    ButtonType["reset"] = "reset";
})(ButtonType || (ButtonType = {}));
export const Button = (_a) => {
    var { children = null, className = '', component = 'button', isActive = false, isBlock = false, isDisabled = false, isInline = false, type = ButtonType.button, variant = ButtonVariant.primary, iconPosition = 'left', 'aria-label': ariaLabel = null, icon = null, ouiaId = null, tabIndex = null } = _a, props = __rest(_a, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isInline", "type", "variant", "iconPosition", 'aria-label', "icon", "ouiaId", "tabIndex"]);
    const Component = component;
    const isButtonElement = Component === 'button';
    return (React.createElement(Component, Object.assign({}, props, { "aria-disabled": isButtonElement ? null : isDisabled, "aria-label": ariaLabel, className: css(styles.button, styles.modifiers[variant], isBlock && styles.modifiers.block, isDisabled && !isButtonElement && styles.modifiers.disabled, isActive && styles.modifiers.active, isInline && variant === ButtonVariant.link && styles.modifiers.inline, className), disabled: isButtonElement ? isDisabled : null, tabIndex: isDisabled && !isButtonElement ? -1 : tabIndex, type: isButtonElement ? type : null }, getOUIAProps('Button', ouiaId)),
        variant !== ButtonVariant.plain && icon && iconPosition === 'left' && (React.createElement("span", { className: css(styles.buttonIcon, styles.modifiers.start) }, icon)),
        children,
        variant !== ButtonVariant.plain && icon && iconPosition === 'right' && (React.createElement("span", { className: css(styles.buttonIcon, styles.modifiers.end) }, icon))));
};
//# sourceMappingURL=Button.js.map