import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Dropdown/dropdown';
import { DropdownContext } from './dropdownConstants';
import { DropdownWithContext } from './DropdownWithContext';
export const Dropdown = (_a) => {
    var { onSelect, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref } = _a, // Types of Ref are different for React.FC vs React.Component
    props = __rest(_a, ["onSelect", "ref"]);
    return (React.createElement(DropdownContext.Provider, { value: {
            onSelect: event => onSelect && onSelect(event),
            toggleTextClass: styles.dropdownToggleText,
            toggleIconClass: styles.dropdownToggleImage,
            toggleIndicatorClass: styles.dropdownToggleIcon,
            menuClass: styles.dropdownMenu,
            itemClass: styles.dropdownMenuItem,
            toggleClass: styles.dropdownToggle,
            baseClass: styles.dropdown,
            baseComponent: 'div',
            sectionClass: styles.dropdownGroup,
            sectionTitleClass: styles.dropdownGroupTitle,
            sectionComponent: 'section',
            disabledClass: styles.modifiers.disabled,
            plainTextClass: styles.modifiers.text
        } },
        React.createElement(DropdownWithContext, Object.assign({}, props))));
};
//# sourceMappingURL=Dropdown.js.map