"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const dropdownConstants_1 = require("./dropdownConstants");
const constants_1 = require("../../helpers/constants");
const Tooltip_1 = require("../Tooltip");
const dropdown_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Dropdown/dropdown"));
class InternalDropdownItem extends React.Component {
    constructor() {
        super(...arguments);
        this.ref = React.createRef();
        this.additionalRef = React.createRef();
        this.getInnerNode = (node) => (node && node.childNodes && node.childNodes.length ? node.childNodes[0] : node);
        this.onKeyDown = (event) => {
            // Detected key press on this item, notify the menu parent so that the appropriate item can be focused
            const innerIndex = event.target === this.ref.current ? 0 : 1;
            if (!this.props.customChild) {
                event.preventDefault();
            }
            if (event.key === 'ArrowUp') {
                this.props.context.keyHandler(this.props.index, innerIndex, constants_1.KEYHANDLER_DIRECTION.UP);
            }
            else if (event.key === 'ArrowDown') {
                this.props.context.keyHandler(this.props.index, innerIndex, constants_1.KEYHANDLER_DIRECTION.DOWN);
            }
            else if (event.key === 'ArrowRight') {
                this.props.context.keyHandler(this.props.index, innerIndex, constants_1.KEYHANDLER_DIRECTION.RIGHT);
            }
            else if (event.key === 'ArrowLeft') {
                this.props.context.keyHandler(this.props.index, innerIndex, constants_1.KEYHANDLER_DIRECTION.LEFT);
            }
            else if (event.key === 'Enter' || event.key === ' ') {
                event.target.click();
                this.props.enterTriggersArrowDown &&
                    this.props.context.keyHandler(this.props.index, innerIndex, constants_1.KEYHANDLER_DIRECTION.DOWN);
            }
        };
    }
    componentDidMount() {
        const { context, index, isDisabled, role, customChild } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        context.sendRef(index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }
    componentDidUpdate() {
        const { context, index, isDisabled, role, customChild } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        context.sendRef(index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }
    extendAdditionalChildRef() {
        const { additionalChild } = this.props;
        return React.cloneElement(additionalChild, {
            ref: this.additionalRef
        });
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { className, children, isHovered, context, onClick, component, role, isDisabled, isPlainText, index, href, tooltip, tooltipProps, id, componentID, listItemClassName, additionalChild, customChild, enterTriggersArrowDown, icon } = _a, additionalProps = tslib_1.__rest(_a, ["className", "children", "isHovered", "context", "onClick", "component", "role", "isDisabled", "isPlainText", "index", "href", "tooltip", "tooltipProps", "id", "componentID", "listItemClassName", "additionalChild", "customChild", "enterTriggersArrowDown", "icon"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        const Component = component;
        let classes;
        if (Component === 'a') {
            additionalProps['aria-disabled'] = isDisabled;
            additionalProps.tabIndex = isDisabled ? -1 : additionalProps.tabIndex;
        }
        else if (Component === 'button') {
            additionalProps.disabled = isDisabled;
            additionalProps.type = additionalProps.type || 'button';
        }
        const renderWithTooltip = (childNode) => tooltip ? (React.createElement(Tooltip_1.Tooltip, Object.assign({ content: tooltip }, tooltipProps), childNode)) : (childNode);
        return (React.createElement(dropdownConstants_1.DropdownContext.Consumer, null, ({ onSelect, itemClass, disabledClass, plainTextClass }) => {
            if (this.props.role === 'separator') {
                classes = react_styles_1.css(icon && dropdown_1.default.modifiers.icon, className);
            }
            else {
                classes = react_styles_1.css(icon && dropdown_1.default.modifiers.icon, className, isDisabled && disabledClass, isPlainText && plainTextClass, itemClass);
            }
            if (customChild) {
                return React.cloneElement(customChild, {
                    ref: this.ref,
                    onKeyDown: this.onKeyDown
                });
            }
            return (React.createElement("li", { className: listItemClassName || null, role: role, onKeyDown: this.onKeyDown, onClick: (event) => {
                    if (!isDisabled) {
                        onClick(event);
                        onSelect(event);
                    }
                }, id: id },
                renderWithTooltip(React.isValidElement(component) ? (React.cloneElement(component, {
                    className: react_styles_1.css(component.props.className, classes)
                })) : (React.createElement(Component, Object.assign({}, additionalProps, { href: href, ref: this.ref, className: classes, id: componentID }),
                    icon && React.createElement("span", { className: react_styles_1.css(dropdown_1.default.dropdownMenuItemIcon) }, icon),
                    children))),
                additionalChild && this.extendAdditionalChildRef()));
        }));
    }
}
exports.InternalDropdownItem = InternalDropdownItem;
InternalDropdownItem.defaultProps = {
    className: '',
    isHovered: false,
    component: 'a',
    role: 'none',
    isDisabled: false,
    isPlainText: false,
    tooltipProps: {},
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (event) => undefined,
    index: -1,
    context: {
        keyHandler: () => { },
        sendRef: () => { }
    },
    enterTriggersArrowDown: false,
    icon: null
};
//# sourceMappingURL=InternalDropdownItem.js.map