"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = applyStyle;
exports.CURSOR_STYLE_UNDERLINE_CLASS = exports.CURSOR_STYLE_BAR_CLASS = exports.CURSOR_STYLE_BLOCK_CLASS = exports.CURSOR_BLINK_CLASS = exports.CURSOR_CLASS = exports.UNDERLINE_CLASS = exports.ITALIC_CLASS = exports.DIM_CLASS = exports.BOLD_CLASS = exports.WHITESPACE_CELL_CHAR = exports.NULL_CELL_CODE = exports.INVERTED_DEFAULT_COLOR = void 0;

/**
 * Copyright (c) 2018 The xterm.js authors. All rights reserved.
 * @license MIT
 */
// import { INVERTED_DEFAULT_COLOR } from 'browser/renderer/atlas/Constants';
const INVERTED_DEFAULT_COLOR = 257; // import { NULL_CELL_CODE, WHITESPACE_CELL_CHAR, Attributes } from 'common/buffer/Constants';

exports.INVERTED_DEFAULT_COLOR = INVERTED_DEFAULT_COLOR;
const NULL_CELL_CODE = 0;
exports.NULL_CELL_CODE = NULL_CELL_CODE;
const WHITESPACE_CELL_CHAR = ' '; // rest from DomRenderRowFactory.ts

exports.WHITESPACE_CELL_CHAR = WHITESPACE_CELL_CHAR;
const BOLD_CLASS = 'xterm-bold';
exports.BOLD_CLASS = BOLD_CLASS;
const DIM_CLASS = 'xterm-dim';
exports.DIM_CLASS = DIM_CLASS;
const ITALIC_CLASS = 'xterm-italic';
exports.ITALIC_CLASS = ITALIC_CLASS;
const UNDERLINE_CLASS = 'xterm-underline';
exports.UNDERLINE_CLASS = UNDERLINE_CLASS;
const CURSOR_CLASS = 'xterm-cursor';
exports.CURSOR_CLASS = CURSOR_CLASS;
const CURSOR_BLINK_CLASS = 'xterm-cursor-blink';
exports.CURSOR_BLINK_CLASS = CURSOR_BLINK_CLASS;
const CURSOR_STYLE_BLOCK_CLASS = 'xterm-cursor-block';
exports.CURSOR_STYLE_BLOCK_CLASS = CURSOR_STYLE_BLOCK_CLASS;
const CURSOR_STYLE_BAR_CLASS = 'xterm-cursor-bar';
exports.CURSOR_STYLE_BAR_CLASS = CURSOR_STYLE_BAR_CLASS;
const CURSOR_STYLE_UNDERLINE_CLASS = 'xterm-cursor-underline';
exports.CURSOR_STYLE_UNDERLINE_CLASS = CURSOR_STYLE_UNDERLINE_CLASS;

function padStart(text, padChar, length) {
  while (text.length < length) {
    text = padChar + text;
  }

  return text;
}

function _addStyle(element, style) {
  element.setAttribute('style', `${element.getAttribute('style') || ''}${style};`);
}
/**
 * Apply the styling from `_workCell` to the given `charElement`.
 *
 * Attribution: from DomRenderRofFactory.createRow xterm v4.4.0
 *
 */


function applyStyle(charElement, _workCell) {
  if (_workCell.isBold()) {
    charElement.classList.add(BOLD_CLASS);
  }

  if (_workCell.isItalic()) {
    charElement.classList.add(ITALIC_CLASS);
  }

  if (_workCell.isDim()) {
    charElement.classList.add(DIM_CLASS);
  }

  if (_workCell.isUnderline()) {
    charElement.classList.add(UNDERLINE_CLASS);
  }

  if (_workCell.isInvisible()) {
    charElement.textContent = WHITESPACE_CELL_CHAR;
  } else {
    charElement.textContent = _workCell.getChars() || WHITESPACE_CELL_CHAR;
  }

  let fg = _workCell.getFgColor();

  let fgColorMode = _workCell.getFgColorMode();

  let bg = _workCell.getBgColor();

  let bgColorMode = _workCell.getBgColorMode();

  const isInverse = !!_workCell.isInverse();

  if (isInverse) {
    const temp = fg;
    fg = bg;
    bg = temp;
    const temp2 = fgColorMode;
    fgColorMode = bgColorMode;
    bgColorMode = temp2;
  } // Foreground


  switch (fgColorMode) {
    case 16777216
    /* CM_P16 */
    :
    case 33554432
    /* CM_P256 */
    :
      // if (_workCell.isBold() && fg < 8 && this._optionsService.options.drawBoldTextInBrightColors) {
      // fg += 8;
      // }
      // if (!this._applyMinimumContrast(charElement, this._colors.background, this._colors.ansi[fg])) {
      charElement.classList.add(`xterm-fg-${fg}`); // }

      break;

    case 50331648
    /* CM_RGB */
    :
      /* const color = rgba.toColor(
        (fg >> 16) & 0xFF,
        (fg >>  8) & 0xFF,
        (fg      ) & 0xFF
      ); */
      // if (!this._applyMinimumContrast(charElement, this._colors.background, color)) {
      _addStyle(charElement, `color:#${padStart(fg.toString(16), '0', 6)}`); // }


      break;

    case 0
    /* CM_DEFAULT */
    :
    default:
      // if (!this._applyMinimumContrast(charElement, this._colors.background, this._colors.foreground)) {
      if (isInverse) {
        charElement.classList.add(`xterm-fg-${INVERTED_DEFAULT_COLOR}`);
      }

    // }
  } // Background


  switch (bgColorMode) {
    case 16777216
    /* CM_P16 */
    :
    case 33554432
    /* CM_P256 */
    :
      charElement.classList.add(`xterm-bg-${bg}`);
      break;

    case 50331648
    /* CM_RGB */
    :
      _addStyle(charElement, `background-color:#${padStart(bg.toString(16), '0', 6)}`);

      break;

    case 0
    /* CM_DEFAULT */
    :
    default:
      if (isInverse) {
        charElement.classList.add(`xterm-bg-${INVERTED_DEFAULT_COLOR}`);
      }

  }
}