function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Tag from '../Tag';
import TagSkeleton from '../Tag/Tag.Skeleton';
import { shallow } from 'enzyme';
import { settings } from 'carbon-components';
import { render, cleanup } from '@carbon/test-utils/react';
var prefix = settings.prefix;
describe('Tag', function () {
  afterEach(cleanup);
  describe('automated accessibility testing', function () {
    it('should have no Axe violations',
    /*#__PURE__*/
    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee() {
      var _render, container;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _render = render(React.createElement(Tag, {
                type: "red"
              }, "This is not a tag")), container = _render.container;
              _context.next = 3;
              return expect(container).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no DAP violations',
    /*#__PURE__*/
    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee2() {
      var _render2, container;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _render2 = render(React.createElement("main", null, React.createElement(Tag, {
                type: "red"
              }, "This is not a tag"))), container = _render2.container;
              _context2.next = 3;
              return expect(container).toHaveNoDAPViolations('Tag');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  describe('with a screenreader', function () {
    it('filtered variant should have appropriate aria-label', function () {
      var children = 'tag content';

      var _render3 = render(React.createElement(Tag, {
        type: "red",
        filter: true
      }, children)),
          container = _render3.container;

      var button = container.querySelector('[aria-label], [aria-labelledby]');
      var accessibilityLabel = button.getAttribute('aria-label') || button.getAttribute('aria-labelledby'); // This check would mirror our "Accessibility label must contain at least all of visible label"
      // requirement

      expect(accessibilityLabel).toEqual(expect.stringContaining(children));
    });
  });
  describe('Renders as expected', function () {
    it('should render with the appropriate type', function () {
      var tag = shallow(React.createElement(Tag, {
        type: "red"
      }));
      expect(tag.hasClass("".concat(prefix, "--tag"))).toEqual(true);
      expect(tag.hasClass("".concat(prefix, "--tag--red"))).toEqual(true);
    });
  });
  it('should allow for a custom label', function () {
    var tag = shallow(React.createElement(Tag, {
      type: "red"
    }, "New Version!"));
    expect(tag.text()).toEqual('New Version!');
  });
  it('should support extra class names', function () {
    var tag = shallow(React.createElement(Tag, {
      type: "red",
      className: "extra-class"
    }));
    expect(tag.hasClass('extra-class')).toEqual(true);
  });
});
describe('TagSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = shallow(React.createElement(TagSkeleton, null));
    it('Has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      expect(wrapper.hasClass("".concat(prefix, "--tag"))).toEqual(true);
    });
  });
});