"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isReactProvider = isReactProvider;
exports.isScalarContent = isScalarContent;
exports.isSupportedContentType = isSupportedContentType;
exports.isStringWithOptionalContentType = isStringWithOptionalContentType;
exports.isFunctionContent = isFunctionContent;
exports.isCommandStringContent = isCommandStringContent;
exports.hasContent = hasContent;

var _table = require("../../webapp/models/table");

var _types = require("../../util/types");

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isReactProvider(entity) {
  const provider = entity;
  return typeof provider.react === 'function';
}

function isScalarContent(entity) {
  const content = entity.content;
  return isReactProvider(entity) || content !== undefined && (typeof content === 'string' || (0, _table.isTable)(content) || (0, _types.isHTML)(content));
}

function isSupportedContentType(contentType) {
  return contentType === 'yaml' || contentType === 'text/markdown' || contentType === 'text/html' || contentType === 'text/plain' || contentType === 'json' || contentType === 'shell';
}

function isStringWithOptionalContentType(entity) {
  const str = entity;
  return !!(str && typeof str.content === 'string' && (str.contentType === undefined || typeof str.contentType === 'string'));
}

function isFunctionContent(content) {
  const func = content;
  return !!func && !!func.content && typeof func.content === 'function';
}

function isCommandStringContent(content) {
  const command = content;
  return !!command && typeof command.contentFrom === 'string' && (command.contentType === undefined || isSupportedContentType(command.contentType));
}

function hasContent(resource) {
  return Object.prototype.hasOwnProperty.call(resource, 'content') || Object.prototype.hasOwnProperty.call(resource, 'react') || isCommandStringContent(resource);
}