"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = void 0;

var _capabilities = require("../core/capabilities");

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('webapp/query');
debug('loading');

const init = () => __awaiter(void 0, void 0, void 0, function* () {
  debug('init');

  if ((0, _capabilities.inBrowser)()) {
    const windowQuery = window.location.search;

    if (windowQuery) {
      // parse and extract the question mark in window.location.search
      // e.g. query = { exec: 'action list', namespace: 123@ibm.com_cloudshella }
      const query = require('querystring').parse(windowQuery.substring(1));

      if (query.command) {
        // execute ?command=<command>
        const {
          pexec
        } = yield Promise.resolve().then(() => require('../repl/exec'));

        const queryExec = () => pexec(query.command);

        queryExec();
      }
    }
  }

  debug('init done');
});

exports.init = init;