import { ParsedOptions } from '../models/command';
/**
 * Turn an options struct into a cli string
 *
 * @param options is the command line options struct given by the
 * user.
 *
 */
export declare const optionsToString: (options: ParsedOptions) => string;
/**
 * Check for unknown options
 *
 */
export declare const hasUnknownOptions: (options: ParsedOptions, expected: string[]) => void;
/** flatten an array of arrays */
export declare function flatten<T>(arrays: T[][]): T[];
