import { ToolbarText } from '../webapp/views/toolbar-text';
declare type Save = void | {
    noToolbarUpdate?: boolean;
    toolbarText?: ToolbarText;
};
export interface SaveError extends Error {
    revealLine?: number;
}
export interface EditableSpec {
    /** Should the editor be opened in read-only mode? Default: false */
    readOnly: boolean;
    /** Should we offer a Clear button? Default: false */
    clearable: boolean;
    /** Button and Controller to handle saves */
    save: {
        label: string;
        onSave(data: string): Save | Promise<Save>;
    };
    /** Button and Controller to handle reverts */
    revert: {
        label?: string;
        onRevert(): string | Promise<string>;
    };
}
/** The Resource trait */
export declare type Editable = {
    spec: EditableSpec;
};
export {};
