/// <reference types="node" />
import { ExecType } from './command';
import { Tab } from '../webapp/tab';
import { Stream, Streamable, StreamableFactory } from './streamable';
import { Block } from '../webapp/models/block';
import { Abortable, FlowControllable } from '../core/jobs/job';
export interface ExecOptions {
    /** force execution in a given tab? */
    tab?: Tab;
    /** execution UUID */
    execUUID?: string;
    /** pass through uninterpreted data */
    data?: string | Buffer | Record<string, any>;
    /** environment variable map */
    env?: Record<string, string>;
    /** true, if you wish a qexec to return rendered HTML; default is false, meaning you get the model back on qexec */
    render?: boolean;
    alwaysViewIn?: 'Terminal';
    isProxied?: boolean;
    noDelegation?: boolean;
    delegationOk?: boolean;
    leaveBottomStripeAlone?: boolean;
    filter?: any;
    contextChangeOK?: boolean;
    credentials?: Record<string, any>;
    custom?: any;
    rawResponse?: boolean;
    isDrilldown?: boolean;
    block?: Block;
    nextBlock?: HTMLElement;
    placeholder?: string;
    replSilence?: boolean;
    quiet?: boolean;
    intentional?: boolean;
    noHistory?: boolean;
    pip?: {
        container: string;
        returnTo: string;
    };
    history?: number;
    echo?: boolean;
    nested?: boolean;
    failWithUsage?: boolean;
    rethrowErrors?: boolean;
    reportErrors?: boolean;
    preserveBackButton?: boolean;
    type?: ExecType;
    exec?: 'pexec' | 'qexec' | 'rexec';
    container?: Element;
    raw?: boolean;
    createOnly?: boolean;
    noHeader?: boolean;
    noStatus?: boolean;
    noSidecarHeader?: boolean;
    noRetry?: boolean;
    showHeader?: boolean;
    alreadyWatching?: boolean;
    createOutputStream?: StreamableFactory;
    stdout?: (str: Streamable) => any;
    stderr?: (str: string) => any;
    /** on job init, pass the job, and get back a stdout; i.e. just before the PTY is brought up */
    onInit?: (job: Abortable & FlowControllable) => Stream | Promise<Stream>;
    /** on job ready, i.e. after the PTY is up, but before any data has been processed */
    onReady?: (job: Abortable & FlowControllable) => void | Promise<void>;
    /** on job exit, pass the exitCode */
    onExit?: (exitCode: number) => void;
    parameters?: any;
    entity?: any;
}
export interface LanguageBearing extends ExecOptions {
    /** navigator.language */
    language: string;
}
export declare function hasLanguage(execOptions: ExecOptions): execOptions is LanguageBearing;
export declare function withLanguage(execOptions: ExecOptions): LanguageBearing;
export declare class DefaultExecOptions implements ExecOptions {
    readonly type: ExecType;
    readonly language: string;
    constructor(type?: ExecType);
}
export declare class DefaultExecOptionsForTab extends DefaultExecOptions {
    readonly tab: Tab;
    readonly block: Block;
    constructor(tab: Tab, block: Block);
}
export default ExecOptions;
