"use strict";

var _test = require("@kui-shell/test");

var _utils = require("@kui-shell/plugin-kubectl/tests/lib/k8s/utils");

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const lists = ['list', 'ls']; // TODO: enable this once proxy can find $HOME on travis

describe(`helm commands ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
  before(_test.Common.before(this));
  after(_test.Common.after(this));
  const ns = (0, _utils.createNS)();
  const inNamespace = `--namespace ${ns}`;
  const name = `test-release-${ns}`;
  it('should show 500 error for helm help --tls', () => {
    return _test.CLI.command('helm help --tls', this.app).then(_test.ReplExpect.error(500, 'Error: unknown flag: --tls')).catch(_test.Common.oops(this, true));
  });
  it('should show 500 error for helm get', () => {
    return _test.CLI.command('helm get', this.app).then(_test.ReplExpect.error(500, 'Error: release name is required')).catch(_test.Common.oops(this, true));
  });

  const help = _utils.doHelp.bind(this);

  help('helm', ['helm'], ['Introduction', 'Options', 'Available']);
  help('helm -h', ['helm'], ['Introduction', 'Options', 'Available']);
  help('helm get -h', ['helm', 'get'], ['Introduction', 'Flags', 'Global Flags', 'Available']);
  it('should show 500 error for helm create', () => {
    return _test.CLI.command('helm create', this.app).then(_test.ReplExpect.error(500, 'Error:')).catch(_test.Common.oops(this, true));
  });
  it('should show 500 error for helm install', () => {
    return _test.CLI.command('helm install', this.app).then(_test.ReplExpect.error(500, 'Error:')).catch(_test.Common.oops(this, true));
  });
  it('should show 500 error for helm delete', () => {
    return _test.CLI.command('helm delete', this.app).then(_test.ReplExpect.error(500, 'Error:')).catch(_test.Common.oops(this, true));
  });
  (0, _utils.allocateNS)(this, ns);
  lists.forEach(list => {
    it(`should list empty releases via helm ${list}`, () => {
      return _test.CLI.command(`helm ${list}`, this.app).then(_test.ReplExpect.blank).catch(_test.Common.oops(this, true));
    });
  });

  const checkHelmInstall = res => __awaiter(this, void 0, void 0, function* () {
    yield _test.ReplExpect.justOK(res);
    yield _test.SidecarExpect.open(res.app);
    yield _test.SidecarExpect.showingTopNav(name)(res.app);
  });

  it(`should create sample helm chart`, () => {
    return _test.CLI.command(`helm install --name ${name} stable/mysql ${inNamespace}`, this.app).then(checkHelmInstall).catch(_test.Common.oops(this, true));
  });
  it('should refresh as a quick way to close the sidecar', () => _test.Common.refresh(this));
  it(`should show history`, () => {
    return _test.CLI.command(`helm history ${name}`, this.app).then(_test.ReplExpect.okWithCustom({
      selector: _test.Selectors.TABLE_CELL('1', 'REVISION')
    })).then(_test.Util.expectText(this.app, '1')).catch(_test.Common.oops(this, true));
  }); // confirm that helm list shows a row for our release

  it(`should list that new release via helm list`, () => {
    return _test.CLI.command(`helm list ${name}`, this.app).then(_test.ReplExpect.okWith(name)).catch(_test.Common.oops(this, true));
  }); // also confirm that there is a REVISION column in that row

  it(`should list that new release via helm list`, () => {
    return _test.CLI.command(`helm list ${name}`, this.app).then(_test.ReplExpect.okWithCustom({
      selector: _test.Selectors.TABLE_CELL(name, 'REVISION')
    })).then(_test.Util.expectText(this.app, '1')).catch(_test.Common.oops(this, true));
  });
  help(`helm status ${name}`, ['helm', 'release', name], ['Status', 'Summary']);
  it(`should show the release in sidecar via helm get`, () => {
    return _test.CLI.command(`helm get ${name}`, this.app).then(_test.ReplExpect.justOK).then(_test.SidecarExpect.open).then(_test.SidecarExpect.showingTopNav(name)).then(() => this.app.client.click(_test.Selectors.SIDECAR_MODE_BUTTON('hooks'))).then(() => this.app.client.click(_test.Selectors.SIDECAR_MODE_BUTTON('manifest'))).then(() => this.app.client.click(_test.Selectors.SIDECAR_MODE_BUTTON('values'))).then(() => this.app.client.click(_test.Selectors.SIDECAR_MODE_BUTTON('notes'))).catch(_test.Common.oops(this, true));
  });
  it(`should delete sample helm chart`, () => {
    return _test.CLI.command(`helm delete --purge ${name}`, this.app).then(_test.ReplExpect.okWithString(`release "${name}" deleted`)).catch(_test.Common.oops(this, true));
  });
  it(`should list empty releases via helm list again`, () => {
    return _test.CLI.command(`helm list ${name}`, this.app).then(_test.ReplExpect.blank).catch(_test.Common.oops(this, true));
  });
  (0, _utils.deleteNS)(this, ns);
});