"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl', 'krew');

var _default = command => args => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _pluginKubectl.isUsage)(args)) {
    // special case: get --help/-h
    return (0, _pluginKubectl.doHelp)(command, args);
  } else {
    // re: the usePty; oddly krew list only emits a subset of the
    // information if it sees a non-pty; so we have to force the use
    // of a pty
    // re: nameColumn; the krew list table diverges from the kubectl
    // standard, and instead uses PLUGIN as the "name" column key
    const stdout = yield (0, _pluginKubectl.doExecWithStdout)(args);
    const keys = stdout.match(/^\S+:/gm);
    const indices = keys.map(key => {
      return stdout.indexOf(key);
    });
    const values = indices.map((keyIdx, idx, A) => {
      return stdout.slice(keyIdx + keys[idx].length, A[idx + 1]).trim();
    });
    const kv = keys.reduce((M, key, idx) => {
      M[key] = values[idx];
      return M;
    }, {});
    const uri = !kv['URI:'] ? [] : [{
      label: strings('Download'),
      href: kv['URI:']
    }];
    const homepage = !kv['HOMEPAGE:'] ? [] : [{
      label: strings('Home Page'),
      href: kv['HOMEPAGE:']
    }];
    const links = uri.concat(homepage);
    const menus = [{
      label: strings('Plugin'),
      items: [{
        mode: 'overview',
        label: strings('Overview'),
        content: keys.filter(_ => _ !== 'HOMEPAGE:' && _ !== 'CAVEATS:' && _ !== 'URI:').reduce((M, key) => {
          return M + `
  ### ${key}
  ${key === 'NAME:' ? '#### ' : ''}${key === 'SHA256:' ? '`' : ''}${kv[key]}${key === 'SHA256:' ? '`' : ''}`;
        }, ''),
        contentType: 'text/markdown'
      }].concat(!kv['CAVEATS:'] ? [] : [{
        mode: 'caveats',
        label: strings('Caveats'),
        contentType: 'text/markdown',
        content: kv['CAVEATS:'].replace(/^\\\n/, '').replace(/\n\/$/, '').replace(/ \| /g, '').replace(/(export \S+=.*)/g, '`$1`').replace(/(%USERPROFILE\S+)/g, '`$1`').replace(/\n\s+\$(.*)/g, '\n   ```\n$1\n   ```\n')
      }])
    }];
    const response = {
      apiVersion: 'kui-shell/v1',
      kind: 'NavResponse',
      menus,
      links,
      breadcrumbs: [{
        label: 'krew',
        command: `kubectl krew list`
      }, {
        label: 'info'
      }, {
        label: values[0]
      }]
    };
    return response;
  }
});

exports.default = _default;