import { Arguments, MultiModalResponse, Registrar, EditableSpec } from '@kui-shell/core';
import { KubeOptions } from './options';
import { KubeResource, KubeItems } from '../../lib/model/resource';
export declare function isEditable(resource: KubeResource): boolean;
export declare function editSpec(cmd: string, namespace: string, args: Arguments<KubeOptions>, resource: KubeResource | KubeItems, applySubCommand?: string): EditableSpec;
export declare function doEdit(cmd: string, args: Arguments<KubeOptions>): Promise<string | number | boolean | HTMLElement | Error | {
    content: string;
    contentType: "text/markdown";
} | import("@kui-shell/core").ReactResponse | import("@kui-shell/core").MixedResponse | import("@kui-shell/core").Table<import("@kui-shell/core").Row> | import("@kui-shell/core").NavResponse | import("@kui-shell/core/mdist/models/RadioTable").default | import("@kui-shell/core").UsageModel | import("@kui-shell/core").ResourceWithMetadata<any> | import("@kui-shell/core").RawResponse<any> | import("@kui-shell/core").ResourceWithMetadata<any>[] | {
    apiVersion: string;
    kind: string;
    metadata: {
        name: string;
        namespace: string;
    };
    spec: EditableSpec;
    modes: {
        mode: string;
        label: string;
        order: any;
        priority: any;
        spec: EditableSpec;
        contentType: string;
        content: string;
    }[];
}>;
export declare function formatToolbarText(args: Arguments<KubeOptions>, response: KubeResource): import("@kui-shell/core").ToolbarText | ({
    type: string;
    text: string;
} & {
    alerts: {
        type: string;
        title: string;
    }[];
});
/**
 * Variant of `resource` enhanced with an `Editable` impl that saves
 * via kubectl apply.
 *
 */
export declare function editable(cmd: string, args: Arguments<KubeOptions>, response: KubeResource): Promise<MultiModalResponse>;
/** KubeResource -> MultiModalResponse view transformer */
export declare function viewTransformer(cmd: string, args: Arguments<KubeOptions>, response: KubeResource | KubeItems): Promise<import("@kui-shell/core").ResourceWithMetadata<void> & import("@kui-shell/core/mdist/models/mmr/types").View<import("@kui-shell/core").ResourceWithMetadata<void>> & {
    defaultMode: string;
}>;
export declare const editFlags: (cmd: string) => import("@kui-shell/core").CommandOptions & {
    viewTransformer: any;
};
export declare function register(registrar: Registrar, cmd: string): void;
export default function registerForKubectl(registrar: Registrar): void;
