/*
 * Copyright 2018-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, Selectors, ReplExpect } from '@kui-shell/test';
import { createNS, allocateNS, doHelp } from '../../../tests/lib/k8s/utils';
import * as assert from 'assert';
const commonModes = ['Introduction', 'Options'];
const kubectlApiResourcesModes = commonModes.concat(['api-resources']);
describe('kubectl api-resources', function () {
    before(Common.before(this));
    after(Common.after(this));
    const ns = createNS();
    allocateNS(this, ns);
    it('should get a list of api resources', () => CLI.command('kubectl api-resources', this.app)
        .then((res) => __awaiter(this, void 0, void 0, function* () {
        yield ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('bindings') })(res);
        const actualTitle = yield this.app.client.getText(Selectors.TABLE_TITLE(res.count));
        assert.strictEqual(actualTitle, 'api-resources');
    }))
        .catch(Common.oops(this, true)));
    xit('should get a list of api resources with pagination', () => CLI.command('kubectl api-resources', this.app)
        .then((res) => __awaiter(this, void 0, void 0, function* () {
        console.error('api-resource table');
        yield ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('bindings') })(res);
        const actualTitle = yield this.app.client.getText(Selectors.TABLE_TITLE(res.count));
        assert.strictEqual(actualTitle, 'api-resources');
        console.error('api-resource pagination forward');
        yield this.app.client.waitForExist(Selectors.TABLE_PAGINATION_FORWARD(res.count));
        yield this.app.client.click(Selectors.TABLE_PAGINATION_FORWARD(res.count));
        console.error('api-resource 10 rows per page');
        const testNumOfRows1 = yield this.app.client.execute(tableSelector => {
            const numRowsOfTable = document.querySelectorAll(tableSelector).length;
            return numRowsOfTable === 10;
        }, Selectors.LIST_RESULTS_N(res.count));
        assert.strictEqual(testNumOfRows1.value, true);
        console.error('api-resource two deployment rows with different apigroup');
        const testNumOfDeploymentsRows = yield this.app.client.execute(deploymentRowsSelector => {
            // should see two deployments rows (NOTE: this behavior depends on different version of kubectl)
            const deploymentRows = document.querySelectorAll(deploymentRowsSelector);
            const numDeploymentRows = deploymentRows.length;
            const apiGroup1 = deploymentRows[0].textContent;
            const apiGroup2 = deploymentRows[1].textContent;
            return numDeploymentRows === 2 && apiGroup1 === 'apps' && apiGroup2 === 'extensions';
        }, `${Selectors.OUTPUT_N(res.count)} ${Selectors.TABLE_CELL('deployments', 'APIGROUP')}`);
        assert.strictEqual(testNumOfDeploymentsRows.value, true);
        console.error('api-resource pagination backward');
        yield this.app.client.waitForExist(Selectors.TABLE_PAGINATION_BACKWARD(res.count));
        yield this.app.client.click(Selectors.TABLE_PAGINATION_BACKWARD(res.count));
        console.error('api-resource table after backward');
        yield ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('bindings') })(res);
        console.error('api-resource 10 rows per page after backward');
        const testNumOfRows2 = yield this.app.client.execute(tableSelector => {
            const numRowsOfTable = document.querySelectorAll(tableSelector).length;
            return numRowsOfTable === 10;
        }, Selectors.LIST_RESULTS_N(res.count));
        assert.strictEqual(testNumOfRows2.value, true);
    }))
        .catch(Common.oops(this, true)));
    it('should get a list of api resources', () => CLI.command('kubectl api-resources --namespaced=true', this.app)
        .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('bindings') }))
        .catch(Common.oops(this, true)));
    it('should get a list of api resources', () => CLI.command('kubectl api-resources --api-group=extensions', this.app)
        .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('daemonsets') }))
        .catch(Common.oops(this, true)));
    const help = doHelp.bind(this);
    help('kubectl api-resources -h', ['kubectl', 'api-resources'], kubectlApiResourcesModes);
});
//# sourceMappingURL=api-resources.js.map