/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors, SidecarExpect } from '@kui-shell/test';
import { createNS, allocateNS, deleteNS, waitForGreen, defaultModeForGet } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
const file = 'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod';
const name = 'nginx';
commands.forEach(command => {
    describe(`kubectl Events tab ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        it('should create sample pod from URL', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${command} create -f ${file} ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }));
                yield waitForGreen(this.app, selector);
                yield this.app.client.waitForExist(`${selector} .clickable`);
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing(name));
            }
            catch (err) {
                yield Common.oops(this, true);
            }
        }));
        it('should switch to Events tab', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('events'));
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('events'));
                yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('events'));
                yield SidecarExpect.toolbarText({ type: 'info', text: 'Events are live streaming', exact: false });
            }
            catch (err) {
                yield Common.oops(this, true);
            }
        }));
        const currentEventCount = () => __awaiter(this, void 0, void 0, function* () {
            const events = yield this.app.client.elements(`${Selectors.SIDECAR} .kui--kubectl-event-record`);
            return !events || !events.value ? 0 : events.value.length;
        });
        it('should expect at least one event, since we just created the resource', () => {
            return this.app.client
                .waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                return (yield currentEventCount()) > 0;
            }))
                .catch(Common.oops(this, true));
        });
        it('should delete the resource via the terminal and see at least one new event', () => __awaiter(this, void 0, void 0, function* () {
            const eventCountBefore = yield currentEventCount();
            yield CLI.command(`kubectl delete -f ${file} ${inNamespace}`, this.app);
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const eventCountAfter = yield currentEventCount();
                return eventCountAfter > eventCountBefore;
            }));
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=events-tab.js.map