"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _raw = _interopRequireDefault(require("./controller/raw"));

var _list = require("./controller/odo/project/list");

var _components = _interopRequireDefault(require("./controller/odo/catalog/list/components"));

var _services = _interopRequireDefault(require("./controller/odo/catalog/list/services"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function withHelp(handler) {
  return args => {
    if ((0, _pluginKubectl.isUsage)(args)) {
      // special case: get --help/-h
      return (0, _pluginKubectl.doHelp)('odo', args);
    }

    return handler(args);
  };
}

var _default = registrar => {
  (0, _raw.default)(registrar);
  registrar.listen(`/${_pluginKubectl.commandPrefix}/odo/project/list`, withHelp(_list.projectList), Object.assign({}, _pluginKubectl.defaultFlags, {
    viewTransformer: _list.projectListView
  }));
  registrar.listen(`/${_pluginKubectl.commandPrefix}/odo/catalog/list/components`, withHelp(_components.default), _pluginKubectl.defaultFlags);
  registrar.listen(`/${_pluginKubectl.commandPrefix}/odo/catalog/list/services`, withHelp(_services.default), _pluginKubectl.defaultFlags);
};

exports.default = _default;