"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.radioTableHintsAsCss = radioTableHintsAsCss;
exports.radioTableCellToString = radioTableCellToString;
exports.cellShouldHaveBadge = cellShouldHaveBadge;
exports.isRadioTable = isRadioTable;

var _CellShould = require("./CellShould");

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function radioTableHintsAsCss(cell) {
  if (typeof cell !== 'string' && cell.hints) {
    if (Array.isArray(cell.hints)) {
      return cell.hints.map(_ => _.toString()).join(' ');
    } else {
      return cell.hints.toString();
    }
  }
}
/** Project the string value of the given `cell` */


function radioTableCellToString(cell) {
  return typeof cell === 'string' ? cell : cell.value;
}
/** Should the cell be rendered with a traffic light badge? */


function cellShouldHaveBadge(cell) {
  return typeof cell !== 'string' && (0, _CellShould.cellShouldHaveBadge)(cell.hints);
}

function isRadioTable(response) {
  if (typeof response === 'object') {
    const table = response;
    return table.apiVersion === 'kui-shell/v1' && table.kind === 'RadioTable';
  } else {
    return false;
  }
}