import { Screen } from 'electron';
import ISubwindowPrefs from '../models/SubwindowPrefs';
export declare function createWindow(noHeadless?: boolean, executeThisArgvPlease?: string[], subwindowPlease?: boolean, subwindowPrefs?: ISubwindowPrefs): void;
/**
 * Strip off the command to be executed from the given argv
 *
 */
interface Command {
    argv: string[];
    subwindowPlease: boolean;
    subwindowPrefs: ISubwindowPrefs;
}
export declare const getCommand: (argv: string[], screen: () => Promise<Screen>) => Command;
/**
 * Spawn electron
 *
 */
export declare function initElectron(command?: string[], { isRunningHeadless }?: {
    isRunningHeadless?: boolean;
}, subwindowPlease?: boolean, subwindowPrefs?: ISubwindowPrefs): Promise<void>;
export {};
