/*
 * Copyright 2019-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export class Row {
    constructor(row) {
        Object.assign(this, row);
    }
}
export class Cell {
    constructor(cell) {
        Object.assign(this, cell);
    }
}
export var TableStyle;
(function (TableStyle) {
    TableStyle[TableStyle["Light"] = 0] = "Light";
    TableStyle[TableStyle["Medium"] = 1] = "Medium";
    TableStyle[TableStyle["Heavy"] = 2] = "Heavy";
})(TableStyle || (TableStyle = {}));
export class Table {
    constructor(table) {
        Object.assign(this, table);
    }
}
export function isTable(model) {
    return (model !== undefined &&
        (model instanceof Table || (model.body !== undefined && Array.isArray(model.body))));
}
export class Icon {
    constructor(icon) {
        Object.assign(this, icon);
    }
}
//# sourceMappingURL=table.js.map