import REPL from '../models/repl';
import TabState from '../models/tab-state';
export interface Tab extends HTMLDivElement {
    uuid: string;
    REPL: REPL;
    state: TabState;
    queueListener: EventListener;
    _kui_session: Promise<any>;
    onActivate(handler: (isActive: boolean) => void): void;
    offActivate(handler: (isActive: boolean) => void): void;
    addClass(cls: string): void;
    removeClass(cls: string): void;
    scrollToBottom(): void;
    getSize(): {
        width: number;
        height: number;
    };
}
export declare function isTab(node: Element | Tab): node is Tab;
/**
 * Return the unique identifier for the given tab
 *
 */
export declare function getTabId(tab: Tab): string;
export declare function getTabIds(tab: Tab): string[];
export declare function getPrimaryTabId(tab: Tab): string;
export declare const sameTab: (tab1: Tab, tab2: Tab) => boolean;
export declare const getCurrentTab: () => Tab;
export declare const getTab: (idx: number | Tab) => Tab;
export declare function pexecInCurrentTab(command: string): Promise<import("../models/entity").Entity<any, import("..").Row, import("..").ResourceWithMetadata<any>>>;
export default Tab;
