"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _showCrdManagedResources = require("./show-crd-managed-resources");

var _resource = require("../../model/resource");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');
const debug = (0, _debug.default)('plugin-kubectl/view/modes/crd-summary');
/**
 * Extract the events
 *
 */

function content(tab, crd, args) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      group,
      version,
      scope
    } = crd.spec;
    const kind = crd.spec.names.kind; // safeguarding here, in case some of the fields are undefined;
    // js-yaml does not take kindly to `undefined` values; see
    // https://github.com/kui-shell/plugin-kubeui/issues/330

    const scopeObj = scope ? {
      Scope: scope
    } : {};
    const groupObj = group ? {
      Group: group
    } : {};
    const versionObj = version ? {
      Version: version
    } : {};
    const kindObj = kind ? {
      Kind: kind
    } : {};
    const baseResponse = Object.assign({}, scopeObj, groupObj, versionObj, kindObj);
    const jsyaml = Promise.resolve().then(() => require('js-yaml'));

    try {
      const {
        body: resources
      } = yield tab.REPL.qexec(`${(0, _showCrdManagedResources.command)(tab, crd, args)} -o custom-columns=NAME:.metadata.name`);
      baseResponse['Resource count'] = resources.length;
    } catch (err) {
      // safeguarding here, in case of unexpected errors collecting
      // optional information; see
      // https://github.com/kui-shell/plugin-kubeui/issues/330
      debug('error fetching resource count for crd', err);
    }

    return {
      content: (yield jsyaml).safeDump(baseResponse),
      contentType: 'yaml'
    };
  });
}
/**
 * Add a Events mode button to the given modes model, if called for by
 * the given resource.
 *
 */


const mode = {
  when: _resource.isCustomResourceDefinition,
  mode: {
    mode: 'summary',
    label: strings('summary'),
    content,
    priority: 10 // override default Summary

  }
};
var _default = mode;
exports.default = _default;