"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const form_control_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/FormControl/form-control"));
const react_styles_1 = require("@patternfly/react-styles");
const constants_1 = require("../../helpers/constants");
class FormSelect extends React.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            this.props.onChange(event.currentTarget.value, event);
        };
        if (!props.id && !props['aria-label']) {
            // eslint-disable-next-line no-console
            console.error('FormSelect requires either an id or aria-label to be specified');
        }
    }
    render() {
        const _a = this.props, { children, className, value, validated, isDisabled, isRequired } = _a, props = tslib_1.__rest(_a, ["children", "className", "value", "validated", "isDisabled", "isRequired"]);
        return (React.createElement("select", Object.assign({}, props, { className: react_styles_1.css(form_control_1.default.formControl, className, validated === constants_1.ValidatedOptions.success && form_control_1.default.modifiers.success), "aria-invalid": validated === constants_1.ValidatedOptions.error, onChange: this.handleChange, disabled: isDisabled, required: isRequired, value: value }), children));
    }
}
exports.FormSelect = FormSelect;
FormSelect.defaultProps = {
    className: '',
    value: '',
    validated: 'default',
    isDisabled: false,
    isRequired: false,
    onBlur: () => undefined,
    onFocus: () => undefined,
    onChange: () => undefined
};
//# sourceMappingURL=FormSelect.js.map