/**
 * Copyright (c) 2018 The xterm.js authors. All rights reserved.
 * @license MIT
 */
// import { INVERTED_DEFAULT_COLOR } from 'browser/renderer/atlas/Constants';
export const INVERTED_DEFAULT_COLOR = 257;
// import { NULL_CELL_CODE, WHITESPACE_CELL_CHAR, Attributes } from 'common/buffer/Constants';
export const NULL_CELL_CODE = 0;
export const WHITESPACE_CELL_CHAR = ' ';
// rest from DomRenderRowFactory.ts
export const BOLD_CLASS = 'xterm-bold';
export const DIM_CLASS = 'xterm-dim';
export const ITALIC_CLASS = 'xterm-italic';
export const UNDERLINE_CLASS = 'xterm-underline';
export const CURSOR_CLASS = 'xterm-cursor';
export const CURSOR_BLINK_CLASS = 'xterm-cursor-blink';
export const CURSOR_STYLE_BLOCK_CLASS = 'xterm-cursor-block';
export const CURSOR_STYLE_BAR_CLASS = 'xterm-cursor-bar';
export const CURSOR_STYLE_UNDERLINE_CLASS = 'xterm-cursor-underline';
function padStart(text, padChar, length) {
    while (text.length < length) {
        text = padChar + text;
    }
    return text;
}
function _addStyle(element, style) {
    element.setAttribute('style', `${element.getAttribute('style') || ''}${style};`);
}
/**
 * Apply the styling from `_workCell` to the given `charElement`.
 *
 * Attribution: from DomRenderRofFactory.createRow xterm v4.4.0
 *
 */
export default function applyStyle(charElement, _workCell) {
    if (_workCell.isBold()) {
        charElement.classList.add(BOLD_CLASS);
    }
    if (_workCell.isItalic()) {
        charElement.classList.add(ITALIC_CLASS);
    }
    if (_workCell.isDim()) {
        charElement.classList.add(DIM_CLASS);
    }
    if (_workCell.isUnderline()) {
        charElement.classList.add(UNDERLINE_CLASS);
    }
    if (_workCell.isInvisible()) {
        charElement.textContent = WHITESPACE_CELL_CHAR;
    }
    else {
        charElement.textContent = _workCell.getChars() || WHITESPACE_CELL_CHAR;
    }
    let fg = _workCell.getFgColor();
    let fgColorMode = _workCell.getFgColorMode();
    let bg = _workCell.getBgColor();
    let bgColorMode = _workCell.getBgColorMode();
    const isInverse = !!_workCell.isInverse();
    if (isInverse) {
        const temp = fg;
        fg = bg;
        bg = temp;
        const temp2 = fgColorMode;
        fgColorMode = bgColorMode;
        bgColorMode = temp2;
    }
    // Foreground
    switch (fgColorMode) {
        case 16777216 /* CM_P16 */:
        case 33554432 /* CM_P256 */:
            // if (_workCell.isBold() && fg < 8 && this._optionsService.options.drawBoldTextInBrightColors) {
            // fg += 8;
            // }
            // if (!this._applyMinimumContrast(charElement, this._colors.background, this._colors.ansi[fg])) {
            charElement.classList.add(`xterm-fg-${fg}`);
            // }
            break;
        case 50331648 /* CM_RGB */:
            /* const color = rgba.toColor(
              (fg >> 16) & 0xFF,
              (fg >>  8) & 0xFF,
              (fg      ) & 0xFF
            ); */
            // if (!this._applyMinimumContrast(charElement, this._colors.background, color)) {
            _addStyle(charElement, `color:#${padStart(fg.toString(16), '0', 6)}`);
            // }
            break;
        case 0 /* CM_DEFAULT */:
        default:
            // if (!this._applyMinimumContrast(charElement, this._colors.background, this._colors.foreground)) {
            if (isInverse) {
                charElement.classList.add(`xterm-fg-${INVERTED_DEFAULT_COLOR}`);
            }
        // }
    }
    // Background
    switch (bgColorMode) {
        case 16777216 /* CM_P16 */:
        case 33554432 /* CM_P256 */:
            charElement.classList.add(`xterm-bg-${bg}`);
            break;
        case 50331648 /* CM_RGB */:
            _addStyle(charElement, `background-color:#${padStart(bg.toString(16), '0', 6)}`);
            break;
        case 0 /* CM_DEFAULT */:
        default:
            if (isInverse) {
                charElement.classList.add(`xterm-bg-${INVERTED_DEFAULT_COLOR}`);
            }
    }
}
//# sourceMappingURL=drrf.js.map