import { Channel } from './channel';
/**
 * Thin wrapper on top of browser WebSocket impl
 *
 */
declare class WebSocketChannel implements Channel {
    private readonly ws;
    private readonly uid;
    private readonly gid;
    constructor(url: string, uid: number, gid: number);
    /** Forcibly close the channel */
    close(): void;
    send(msg: string): void;
    get readyState(): number;
    removeEventListener(eventType: string, handler: any): void;
    on(eventType: string, handler: any): void;
}
export default WebSocketChannel;
