"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _carbonComponentsReact = require("carbon-components-react");

var _context = _interopRequireDefault(require("../context"));

var _NewTabButton = _interopRequireDefault(require("./NewTabButton"));

var _Tab = _interopRequireDefault(require("./Tab"));

var _SplitTerminalButton = _interopRequireDefault(require("./SplitTerminalButton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class TopTabStripe extends React.PureComponent {
  componentDidMount() {
    this.addKeyboardListeners();
  }
  /**
   * Register any keyboard event listeners
   *
   */


  addKeyboardListeners() {
    if ((0, _core.inElectron)()) {
      // switch tabs based on keyboard events
      document.addEventListener('keydown', event => {
        if (event.metaKey && event.shiftKey) {
          // shift-command+[]: switch to previous or next
          const whichDir = event.key;

          if (whichDir === '[' || whichDir === ']') {
            const newIdx = whichDir === '[' ? this.props.activeIdx - 1 : this.props.activeIdx + 1;
            this.props.onSwitchTab(newIdx);
          }

          event.stopPropagation();
          return;
        }

        if (event.ctrlKey) {
          // ctrl+PgUp/PgDown: switch to previous or next
          const whichDir = event.keyCode;

          if (whichDir === _core.KeyCodes.PAGEUP || whichDir === _core.KeyCodes.PAGEDOWN) {
            const newIdx = whichDir === _core.KeyCodes.PAGEUP ? this.props.activeIdx - 1 : this.props.activeIdx + 1;
            this.props.onSwitchTab(newIdx);
          }

          event.stopPropagation();
          return;
        }

        if (event.metaKey) {
          // meta+number: switch to tab by index
          const whichTabStr = event.key;

          if (/\d/.test(whichTabStr)) {
            event.stopPropagation();
            const whichTabIdx = parseInt(whichTabStr, 10);
            this.props.onSwitchTab(whichTabIdx - 1);
          }
        }
      });
    }
  }
  /** Render tabs */


  tabs() {
    return React.createElement(React.Fragment, null, React.createElement(_carbonComponentsReact.HeaderNavigation, {
      "aria-label": "Tabs"
    }, this.props.tabs.map((tab, idx) => React.createElement(_Tab.default, Object.assign({}, this.props, {
      key: idx,
      idx: idx,
      uuid: tab.uuid,
      closeable: this.props.tabs.length > 1,
      active: idx === this.props.activeIdx,
      onCloseTab: idx => this.props.onCloseTab(idx),
      onSwitchTab: idx => this.props.onSwitchTab(idx)
    })))), React.createElement("div", {
      className: "kui--top-tab-buttons"
    }, React.createElement(_NewTabButton.default, {
      onNewTab: () => {
        this.props.onNewTab();
      }
    }), React.createElement(_SplitTerminalButton.default, null)));
  }
  /* private sidenav(args: CarbonHeaderArgs) {
    return <About expanded={args.isSideNavExpanded} />
  } */


  headerMenu(args) {
    return React.createElement(_carbonComponentsReact.HeaderMenuButton, {
      "aria-label": "Open menu",
      isCollapsible: true,
      onClick: args.onClickSideNavExpand,
      isActive: args.isSideNavExpanded
    });
  }

  headerName() {
    return React.createElement(_context.default.Consumer, null, config => React.createElement(_carbonComponentsReact.HeaderName, {
      prefix: ""
    }, config.productName || 'Kui'));
  }
  /** Buttons that appear in the top right */


  buttons() {
    if (this.props.tabs[this.props.activeIdx]) {
      const {
        buttons
      } = this.props.tabs[this.props.activeIdx];
      return React.createElement("div", {
        id: "kui--custom-top-tab-stripe-button-container",
        "num-button": buttons.length,
        className: "kui--hide-in-narrower-windows" // re: kui--hide-in-narrower-windows, see https://github.com/IBM/kui/issues/4459

      }, buttons.map(_ => _.icon));
    }
  }
  /**
   * React render handler
   *
   */


  render() {
    return React.createElement(_carbonComponentsReact.Header, {
      "aria-label": "Header",
      className: "kui--top-tab-stripe"
    }, this.headerName(), this.tabs(), this.buttons());
  }

}

exports.default = TopTabStripe;