"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onClickForCell = onClickForCell;
exports.default = renderCell;

var React = _interopRequireWildcard(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

var _ErrorCell = _interopRequireDefault(require("./ErrorCell"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generate an onclick handler for a cell
 *
 */
function onClickForCell(row, tab, repl, cell, selectRow = () => undefined) {
  const handler = cell ? cell.onclick : row.onclick;

  if (handler === false) {
    return () => handler;
  } else if (typeof handler === 'function') {
    return () => {
      selectRow();
      handler();
    };
  } else {
    const opts = {
      tab,
      echo: !row.onclickSilence
    };

    if (!row.onclickExec || row.onclickExec === 'pexec') {
      return () => {
        selectRow();
        repl.pexec(handler, opts);
      };
    } else {
      return () => {
        selectRow();
        repl.qexec(handler, undefined, undefined, {
          tab
        });
      };
    }
  }
}
/**
 * Render a TableCell part
 *
 */


function renderCell(kuiRow, justUpdated, tab, repl) {
  return function KuiTableCell(cell, cidx) {
    // e.g. is this a badge/status-like cell?
    const tag = cidx > 0 && kuiRow.attributes[cidx - 1].tag; // column key

    const key = cidx > 0 && kuiRow.attributes[cidx - 1].key; // className for the td

    const cellClassName = cidx === 0 ? 'entity-name ' + (kuiRow.outerCSS || '') : (key === 'NAME' ? 'kui--entity-name-secondary ' : key === 'STATUS' ? 'kui--status-cell' : '') + (kuiRow.attributes[cidx - 1].outerCSS || '');
    const outerClassName = 'cell-inner ' + (cidx === 0 ? (kuiRow.css || '') + (kuiRow.onclick ? ' clickable' : '') : (kuiRow.attributes[cidx - 1].css || '') + (kuiRow.attributes[cidx - 1].onclick ? ' clickable' : ''));
    const css = cidx > 0 ? kuiRow.attributes[cidx - 1].css : undefined; // the text value of the cell

    const innerText = kuiRow.attributes[cidx - 1] && kuiRow.attributes[cidx - 1].valueDom || cell.value;
    return React.createElement(_carbonComponentsReact.TableCell, {
      key: cell.id,
      className: cellClassName,
      onClick: onClickForCell(kuiRow, tab, repl, kuiRow.attributes[cidx - 1])
    }, React.createElement("span", {
      "data-key": cidx === 0 ? kuiRow.key : kuiRow.attributes[cidx - 1].key,
      "data-value": cell.value,
      "data-tag": tag,
      className: outerClassName
    }, tag === 'badge' && React.createElement("span", {
      key: css
      /* force restart of animation if color changes */
      ,
      title: innerText,
      className: css || 'kui--status-unknown',
      "data-tag": "badge-circle",
      "data-just-updated": justUpdated || undefined
    }, /red-background/.test(css) ? React.createElement(_ErrorCell.default, null) : undefined), React.createElement("span", {
      className: "kui--cell-inner-text"
    }, innerText)));
  };
}