"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _DropDown = _interopRequireDefault(require("../../spi/DropDown"));

var _Breadcrumb = _interopRequireDefault(require("../../spi/Breadcrumb"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common', 'screenshot');
/**
 * TitleBar
 * ---------------------------------
 * | Kind | Namespace    S | M m x |
 * ---------------------------------
 *  S: Screenshot button
 *  M: Maximize/Restore button [!props.fixedWith]
 *  m: Minimize button [!props.fixedWith]
 *  x: Close button
 *
 *  Kind: props.kind
 *  Namespace: props.namespace
 */

class Window extends React.PureComponent {
  toggleMaximization() {
    try {
      if (this.props.width !== "100%"
      /* Maximized */
      ) {
          this.props.onMaximize();
        } else {
        this.props.onRestore();
      }
    } catch (err) {
      console.error(err);
    }
  }

  toggleClose() {
    this.props.onClose();
  }

  screenshotAction() {
    if ((0, _core.inBrowser)()) {
      return [];
    } else {
      return [{
        label: strings('Screenshot'),
        handler: () => this.props.willScreenshot()
      }];
    }
  }

  overflowButton() {
    if (this.props.width !== "0%"
    /* Closed */
    ) {
        const actions = this.screenshotAction();

        if (actions.length > 0) {
          return React.createElement("div", {
            className: "sidecar-bottom-stripe-button"
          }, React.createElement("a", {
            href: "#"
          }, React.createElement(_DropDown.default, {
            actions: actions,
            className: "kui--sidecar-overflow kui--repl-block-right-element"
          })));
        }
      }
  }

  maximizeButton() {
    if (this.props.width !== "0%"
    /* Closed */
    && !this.props.fixedWidth) {
      const max = this.props.width === "100%"
      /* Maximized */
      ;
      const className = max ? 'unmaximize-button-label' : 'maximize-button-label';
      const icon = max ? React.createElement(_Icons.default, {
        icon: "WindowMinimize"
      }) : React.createElement(_Icons.default, {
        icon: "WindowMaximize"
      });
      const aria = max ? 'Restore' : 'Maximize';
      return React.createElement("div", {
        className: "sidecar-bottom-stripe-button sidecar-bottom-stripe-maximize toggle-sidecar-maximization-button"
      }, React.createElement("span", {
        className: className
      }, React.createElement("div", {
        "aria-label": aria
      }, React.createElement("a", {
        href: "#",
        className: "graphical-icon kui--tab-navigatable kui--notab-when-sidecar-hidden",
        tabIndex: -1,
        onMouseDown: evt => evt.preventDefault(),
        onClick: () => this.toggleMaximization()
      }, icon))));
    }
  }

  quitButton() {
    return React.createElement("div", {
      className: "sidecar-bottom-stripe-button sidecar-bottom-stripe-quit"
    }, React.createElement("a", {
      href: "#",
      className: "graphical-icon kui--tab-navigatable kui--notab-when-sidecar-hidden",
      tabIndex: -1,
      "aria-label": "Close",
      onClick: () => this.props.onClose()
    }, React.createElement(_Icons.default, {
      icon: "WindowClose"
    })));
  }
  /** back button */


  back() {
    if (this.props.back) {
      return this.props.back.enabled ? React.createElement("span", {
        className: "sidecar-bottom-stripe-button"
      }, React.createElement("a", {
        href: "#",
        className: "graphical-icon kui--tab-navigable"
      }, React.createElement(_Icons.default, {
        icon: "Back",
        onClick: this.props.back.onClick,
        onMouseDown: evt => evt.preventDefault(),
        className: "kui--sidecar--titlebar-navigation--back"
      }))) : React.createElement("span", {
        className: "sidecar-bottom-stripe-button disabled"
      }, React.createElement("a", {
        className: "disabled graphical-icon"
      }, React.createElement(_Icons.default, {
        icon: "Back",
        onClick: this.props.back.onClick,
        className: "kui--sidecar--titlebar-navigation--back"
      })));
    }
  }
  /** forward button */


  forward() {
    if (this.props.forward) {
      return this.props.forward.enabled ? React.createElement("span", {
        className: "sidecar-bottom-stripe-button"
      }, React.createElement("a", {
        href: "#",
        className: "graphical-icon kui--tab-navigable"
      }, React.createElement(_Icons.default, {
        icon: "Forward",
        onClick: this.props.forward.onClick,
        onMouseDown: evt => evt.preventDefault(),
        className: "kui--sidecar--titlebar-navigation--forward"
      }))) : React.createElement("span", {
        className: "sidecar-bottom-stripe-button disabled"
      }, React.createElement("a", {
        className: "disabled graphical-icon"
      }, React.createElement(_Icons.default, {
        icon: "Forward",
        onClick: this.props.forward.onClick,
        className: "kui--sidecar--titlebar-navigation--forward"
      })));
    }
  }
  /** render history navigation UI */


  history() {
    const breadcrumbs = this.props.breadcrumbs && this.props.breadcrumbs.filter(_ => _.label);
    return React.createElement("div", {
      className: "kui--sidecar--titlebar-navigation"
    }, this.back(), this.forward(), breadcrumbs && breadcrumbs.length > 0 && React.createElement(_Breadcrumb.default, {
      breadcrumbs: breadcrumbs,
      repl: this.props.repl
    }));
  }

  render() {
    return React.createElement("div", {
      className: 'sidecar-bottom-stripe zoomable' + (this.props.breadcrumbs ? ' kui--sidecar--titlebar-has-breadcrumbs' : '')
    }, this.history(), React.createElement("div", {
      className: "sidecar-bottom-stripe-left-bits"
    }), React.createElement("div", {
      className: "sidecar-bottom-stripe-right-bits"
    }, React.createElement("div", {
      className: "sidecar-window-buttons"
    }, this.overflowButton(), this.maximizeButton(), this.quitButton())));
  }

}

exports.default = Window;