"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _Alert = _interopRequireDefault(require("../../spi/Alert"));

var _Toolbar = _interopRequireDefault(require("./Toolbar"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class ToolbarContainer extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      toolbarText: props.toolbarText
    };
  }
  /** Called by children if they desire an update to the Toolbar */


  onToolbarUpdate(toolbarText, extraButtons, extraButtonsOverride) {
    this.setState({
      toolbarText,
      extraButtons,
      extraButtonsOverride
    });
  }
  /** Graft on the toolbar event management */


  children() {
    if (React.isValidElement(this.props.children)) {
      // ^^^ this check avoids tsc errors
      return React.cloneElement(this.props.children, {
        willUpdateToolbar: this.onToolbarUpdate.bind(this)
      });
    } else {
      return this.props.children;
    }
  }

  render() {
    const toolbarButtons = this.state.extraButtonsOverride && Array.isArray(this.state.extraButtons) ? this.state.extraButtons : this.props.buttons.concat(this.state.extraButtons || []);
    const toolbarHasContent = this.state.toolbarText || toolbarButtons.length !== 0;
    const toolbarHasAlerts = !this.props.noAlerts && this.state.toolbarText && this.state.toolbarText.alerts && this.state.toolbarText.alerts.length !== 0;
    return React.createElement("div", {
      className: "full-height"
    }, toolbarHasContent && React.createElement(_Toolbar.default, {
      tab: this.props.tab,
      response: this.props.response,
      args: this.props.args,
      toolbarText: this.state.toolbarText,
      buttons: toolbarButtons
    }), toolbarHasAlerts && this.state.toolbarText.alerts.map((alert, id) => React.createElement(_Alert.default, {
      key: id,
      alert: alert
    })), React.createElement(React.Suspense, {
      fallback: React.createElement("div", null)
    }, this.children()));
  }

}

exports.default = ToolbarContainer;