"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CarbonIcons;

var React = _interopRequireWildcard(require("react"));

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** we will handle Up specially below */
const icons = {
  At: _iconsReact.At16,
  Add: _iconsReact.Add20,
  Back: _iconsReact.ArrowLeft16,
  CodeBranch: _iconsReact.Branch16,
  Checkmark: _iconsReact.CheckmarkFilled16,
  Edit: _iconsReact.Edit16,
  Error: _iconsReact.ErrorFilled16,
  Forward: _iconsReact.ArrowRight16,
  Grid: _iconsReact.Grid16,
  Info: _iconsReact.InformationFilled16,
  List: _iconsReact.List16,
  Network: _iconsReact.FlashOffFilled20,
  NextPage: _iconsReact.CaretRight20,
  Notification: _iconsReact.NotificationNew20,
  Pause: _iconsReact.PauseOutlineFilled16,
  Play: _iconsReact.PlayFilled16,
  Retry: _iconsReact.Renew16,
  PreviousPage: _iconsReact.CaretLeft20,
  Screenshot: _iconsReact.Camera20,
  ScreenshotInProgress: _iconsReact.CameraAction20,
  Server: _iconsReact.VirtualMachine16,
  Settings: _iconsReact.SettingsAdjust20,
  Split: _iconsReact.SplitScreen20,
  Trash: _iconsReact.TrashCan16,
  TerminalOnly: _iconsReact.Terminal32,
  TerminalPlusSidecar: _iconsReact.Notebook32,
  TerminalPlusWatcher: _iconsReact.Thumbnail_132,
  TerminalSidecarWatcher: _iconsReact.Template32,
  Warning: _iconsReact.WarningAltFilled16,
  WindowMaximize: _iconsReact.Maximize16,
  WindowMinimize: _iconsReact.Minimize16,
  WindowClose: _iconsReact.Close20
};

function CarbonIcons(props) {
  if (props.icon === 'Up') {
    return React.createElement(_iconsReact.JumpLink16, Object.assign({}, props, {
      className: "kui--rotate-180"
    }));
  } else if (props.icon === 'TerminalSidecarWatcher') {
    return React.createElement(_iconsReact.Template32, Object.assign({}, props, {
      className: "kui--rotate-180-then-flip"
    }));
  } else {
    return React.createElement(icons[props.icon], props);
  }
}