/// <reference types="react" />
import { TabState } from '@kui-shell/core';
export declare function uuid(): string;
export interface TopTabButton<P extends {
    key: string;
} = {
    key: string;
}> {
    icon: React.ReactElement<P>;
}
export default class TabModel {
    private readonly _uuid;
    private readonly _state;
    private readonly _buttons;
    constructor(_uuid?: string, _state?: TabState, _buttons?: TopTabButton[]);
    get uuid(): string;
    get state(): TabState;
    get buttons(): TopTabButton<{
        key: string;
    }>[];
    update(buttons: TopTabButton[]): TabModel;
}
