"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.registerCapability = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _config = require("./lib/config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugins/proxy-support/preload');
/**
 * This is the capabilities registraion
 *
 */

const registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _core.inBrowser)()) {
    const {
      proxyServer
    } = yield (0, _config.config)();
    debug('config', proxyServer);

    if (!(0, _config.isDisabled)(proxyServer)) {
      // notify the Capabilities manager that we have extended the
      // capabilities of Kui
      (0, _core.assertHasProxy)();
      (0, _core.assertLocalAccess)();
    }
  }
});
/**
 * This is the module
 *
 */


exports.registerCapability = registerCapability;

var _default = () => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _core.inBrowser)()) {
    const {
      proxyServer
    } = yield (0, _config.config)();
    debug('config', proxyServer);

    if (!(0, _config.isDisabled)(proxyServer)) {
      const ProxyEvaluator = (yield Promise.resolve().then(() => require('./lib/proxy-executor'))).default;
      debug('attempting to establish our proxy executor');
      (0, _core.setEvaluatorImpl)(new ProxyEvaluator());
    }
  }
});

exports.default = _default;