"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _resource = require("../../model/resource");

var _fqn = require("../../../controller/kubectl/fqn");

var _util = require("../../../lib/util/util");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-kubectl');
/** Formulate the delete command line */

function command(tab, resource, args) {
  return `${(0, _util.getCommandFromArgs)(args)} delete ${(0, _fqn.fqnOf)(resource)}`;
}
/** The Delete button mode */


const mode = {
  icon: React.createElement(_pluginClientCommon.Icons, {
    icon: "Trash"
  }),
  mode: 'delete',
  order: 100,
  label: strings('deleteResource'),
  kind: 'drilldown',
  command,
  confirm: true
};
/** The DeleteButton mode registration: a `when` filter and a `mode` definition. */

var _default = {
  when: _resource.isCrudableKubeResource,
  mode
};
exports.default = _default;