"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _pods = _interopRequireDefault(require("./lib/view/modes/pods"));

var _yaml = _interopRequireDefault(require("./lib/view/modes/yaml"));

var _Summary = _interopRequireDefault(require("./lib/view/modes/Summary"));

var _crdSummary = _interopRequireDefault(require("./lib/view/modes/crd-summary"));

var _configmapSummary = _interopRequireDefault(require("./lib/view/modes/configmap-summary"));

var _namespaceSummary = _interopRequireDefault(require("./lib/view/modes/namespace-summary"));

var _logs = _interopRequireDefault(require("./lib/view/modes/logs"));

var _ExecIntoPod = _interopRequireDefault(require("./lib/view/modes/ExecIntoPod"));

var _lastApplied = _interopRequireDefault(require("./lib/view/modes/last-applied"));

var _ShowOwnerButton = _interopRequireDefault(require("./lib/view/modes/ShowOwnerButton"));

var _ShowNodeOfPodButton = _interopRequireDefault(require("./lib/view/modes/ShowNodeOfPodButton"));

var _DeleteButton = _interopRequireDefault(require("./lib/view/modes/DeleteButton"));

var _involvedObject = _interopRequireDefault(require("./lib/view/modes/involved-object"));

var _showCrdManagedResources = _interopRequireDefault(require("./lib/view/modes/show-crd-managed-resources"));

var _EditButton = _interopRequireDefault(require("./lib/view/modes/EditButton"));

var _Events = require("./lib/view/modes/Events");

var _tabCompletion = _interopRequireDefault(require("./lib/tab-completion"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  // register modes
  yield registrar.registerModes(_pods.default, _yaml.default, _Summary.default, _crdSummary.default, _configmapSummary.default, _namespaceSummary.default, _Events.eventsMode, _logs.default, _ExecIntoPod.default, _lastApplied.default, _EditButton.default, _showCrdManagedResources.default, _ShowOwnerButton.default, _ShowNodeOfPodButton.default, _DeleteButton.default, _involvedObject.default); // register badges

  yield registrar.registerBadges(_Events.eventsBadge); // register tab completion provider

  try {
    (0, _tabCompletion.default)();
  } catch (err) {
    // don't utterly fail if we can't install the tab completion
    // https://github.com/IBM/kui/issues/2793
    const debug = (0, _debug.default)('plugins/kubeui/preload');
    debug('error installing kubeui tab-completion extensions', err);
  }
});

exports.default = _default;