"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Breadcrumb = _interopRequireDefault(require("../../spi/Breadcrumb"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Toolbar extends React.PureComponent {
  hasGridButtons() {
    return this.props.gridableColumn !== undefined && this.props.gridableColumn >= 0;
  }

  hasButtons() {
    return this.hasGridButtons();
  }

  gridController() {
    if (this.hasGridButtons()) {
      return React.createElement(React.Fragment, null, React.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-list",
        "data-enabled": !this.props.asGrid,
        onClick: () => this.props.setAsGrid(false)
      }, React.createElement(_Icons.default, {
        icon: "List"
      })), React.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-grid",
        "data-enabled": this.props.asGrid,
        onClick: () => this.props.setAsGrid(true)
      }, React.createElement(_Icons.default, {
        icon: "Grid"
      })));
    }
  }

  previousPage() {
    this.props.setPage(this.props.page - 1);
  }

  nextPage() {
    this.props.setPage(this.props.page + 1);
  }

  paginationController() {
    if (this.props.paginate) {
      const start = (this.props.page - 1) * this.props.pageSize + 1;
      const end = this.props.page * this.props.pageSize;
      const isFirstPage = this.props.page === 1;
      const nPages = Math.ceil(this.props.totalItems / this.props.pageSize);
      const isLastPage = this.props.page === nPages;
      const maxLength = end.toString().length;
      const rangeText = `${start.toString().padStart(maxLength)} \u2014 ${end} of ${this.props.totalItems}`;
      return React.createElement("div", {
        className: "kui--data-table-toolbar-pagination bx--pagination"
      }, React.createElement("span", {
        className: "kui--data-table-toolbar-pagination-info"
      }, rangeText), React.createElement("button", {
        type: "button",
        onMouseDown: evt => evt.preventDefault(),
        disabled: isFirstPage,
        className: 'bx--pagination__button bx--pagination__button--backward' + (isFirstPage ? ' bx--pagination__button--no-index' : ''),
        "aria-label": "Previous page",
        onClick: () => this.previousPage()
      }, React.createElement(_Icons.default, {
        icon: "PreviousPage"
      })), React.createElement("button", {
        type: "button",
        onMouseDown: evt => evt.preventDefault(),
        disabled: isLastPage,
        className: 'bx--pagination__button bx--pagination__button--forward' + (isLastPage ? ' bx--pagination__button--no-index' : ''),
        "aria-label": "Next page",
        onClick: () => this.nextPage()
      }, React.createElement(_Icons.default, {
        icon: "NextPage"
      })));
    }
  }

  breadcrumbs() {
    if (this.props.breadcrumbs) {
      return React.createElement(_Breadcrumb.default, {
        breadcrumbs: this.props.breadcrumbs,
        repl: this.props.repl
      });
    }
  }

  buttons() {
    if (this.hasButtons()) {
      return React.createElement("div", {
        className: "kui--data-table-toolbar-buttons"
      }, this.gridController());
    }
  }
  /** so that buttons are flush-left and pagination is flush-right */


  filler() {
    return React.createElement("div", {
      className: "kui--data-table-toolbar-filler"
    });
  }

  render() {
    const className = 'kui--data-table-toolbar' + (this.props.className ? ` ${this.props.className}` : '');
    return React.createElement("div", {
      className: className,
      "data-frame": this.props.framed
    }, this.breadcrumbs(), this.buttons(), this.filler(), this.paginationController());
  }

}

exports.default = Toolbar;