"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _carbonComponentsReact = require("carbon-components-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-core-support');

function isActive(state) {
  return state.isActive;
}

class Confirm extends React.PureComponent {
  constructor(props) {
    super(props);
    this.initEvents();
    this.state = {
      isActive: false
    };
  }

  initEvents() {
    const requestChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}`;

    _core.eventChannelUnsafe.on(requestChannel, this.onConfirmStart.bind(this));
  }

  onConfirmStart({
    command,
    asking,
    execUUID
  }) {
    this.setState({
      isActive: true,
      command,
      asking,
      execUUID
    });
  }
  /** User has confirmed the command */


  onConfirm(confirmed) {
    if (isActive(this.state)) {
      this.setState({
        isActive: false
      });
      const responseChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}/execUUID/${this.state.execUUID}/confirmed`;

      _core.eventChannelUnsafe.emit(responseChannel, {
        confirmed
      });
    }
  }

  render() {
    if (!isActive(this.state)) {
      return React.createElement(React.Fragment, null);
    } else {
      return React.createElement(_carbonComponentsReact.Modal, {
        id: "confirm-dialog",
        open: true,
        danger: true,
        modalHeading: strings('pleaseConfirm'),
        primaryButtonText: strings('yesIAmSure'),
        secondaryButtonText: strings('cancel'),
        onRequestSubmit: () => this.onConfirm(true),
        onRequestClose: () => this.onConfirm(false),
        onSecondarySubmit: () => this.onConfirm(false)
      }, React.createElement("p", {
        className: "bx--modal-content__text"
      }, strings('aboutToExecute')), React.createElement("p", {
        className: "bx--modal-content__text"
      }, React.createElement("strong", {
        className: "red-text"
      }, this.state.command)), React.createElement("p", {
        className: "bx--modal-content__text"
      }, this.state.asking || strings('areYouSure')));
    }
  }

}

exports.default = Confirm;