"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _ToolbarButton = _interopRequireDefault(require("./ToolbarButton"));

var _Markdown = _interopRequireDefault(require("../../Content/Markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** helper to ensure exhaustiveness of the switch statement below */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function assertUnreachable(x) {
  throw new Error('Did not expect to get here');
}

class Toolbar extends React.PureComponent {
  icon() {
    if (this.props.toolbarText) {
      const {
        type
      } = this.props.toolbarText;

      switch (type) {
        case 'info':
          return React.createElement(_Icons.default, {
            icon: "Info"
          });

        case 'success':
          return React.createElement(_Icons.default, {
            icon: "Checkmark"
          });

        case 'warning':
          return React.createElement(_Icons.default, {
            icon: "Warning"
          });

        case 'error':
          return React.createElement(_Icons.default, {
            icon: "Error"
          });
      } // this bit of magic ensures exhaustiveness of the switch;
      // reference: https://stackoverflow.com/a/39419171


      return assertUnreachable(type);
    }
  }

  buttons() {
    if (this.props.buttons) {
      return this.props.buttons.sort((a, b) => {
        return (a.order || 0) - (b.order || 0);
      }).map((button, idx) => React.createElement(_ToolbarButton.default, {
        tab: this.props.tab,
        button: button,
        response: this.props.response,
        args: this.props.args,
        key: idx
      }));
    }
  }

  render() {
    try {
      return React.createElement("div", {
        className: "sidecar-bottom-stripe-toolbar"
      }, React.createElement("div", {
        className: "sidecar-toolbar-text",
        "data-type": this.props.toolbarText && this.props.toolbarText.type
      }, React.createElement("div", {
        className: "sidecar-toolbar-text-icon"
      }, this.icon()), this.props.toolbarText && (typeof this.props.toolbarText.text === 'string' ? React.createElement(_Markdown.default, {
        source: this.props.toolbarText.text,
        className: "sidecar-toolbar-text-content"
      }) : React.createElement("div", {
        className: "sidecar-toolbar-text-content",
        dangerouslySetInnerHTML: {
          __html: this.props.toolbarText.text.innerHTML
        }
      }))), React.createElement("div", {
        className: "sidecar-bottom-stripe-mode-bits sidecar-bottom-stripe-button-container"
      }, React.createElement("div", {
        className: "fill-container flex-layout flush-right"
      }, this.buttons())));
    } catch (err) {
      console.error(err);
      return React.createElement("div", null);
    }
  }

}

exports.default = Toolbar;