"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

var _Icons = _interopRequireDefault(require("../../Icons"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class CarbonDropDown extends React.PureComponent {
  onClose() {
    if (this.props.onClose) {
      this.props.onClose();
    }
  }

  render() {
    return React.createElement(_carbonComponentsReact.OverflowMenu, {
      flipped: true,
      menuOptionsClass: this.props.className,
      className: this.props.className,
      onClose: this.onClose.bind(this)
    }, this.props.actions.map((_, idx) => {
      const selectedItem = (label, isSelected) => React.createElement(React.Fragment, null, React.createElement("span", {
        className: "small-right-pad",
        style: !isSelected ? {
          opacity: 0
        } : undefined
      }, React.createElement(_Icons.default, {
        icon: "Checkmark",
        "data-mode": "selected container"
      })), React.createElement("div", {
        className: "bx--overflow-menu-options__option-content"
      }, label));

      return React.createElement(_carbonComponentsReact.OverflowMenuItem, {
        hasDivider: _.hasDivider,
        key: idx,
        itemText: selectedItem(_.label, _.isSelected),
        onClick: () => setTimeout(() => _.handler()),
        "data-mode": _.label
      });
    }));
  }

}

exports.default = CarbonDropDown;