import * as React from 'react';
import KuiConfiguration from './KuiConfiguration';
export declare type Props = Partial<KuiConfiguration> & {
    /** no Kui bootstrap needed? */
    noBootstrap?: boolean;
    /** operate in bottom Input mode? rather than as a conventional Input/Output terminal */
    bottomInput?: true | React.ReactNode;
    /** Elements to place between TabContainer and StatusStripe */
    toplevel?: React.ReactNode | React.ReactNode[];
    /** operate in popup mode? */
    isPopup?: boolean;
    /** if in popup mode, execute the given command line */
    commandLine?: string[];
};
declare type State = KuiConfiguration & {
    isBootstrapped: boolean;
};
/**
 * Render the main body of our client.
 *
 * |Notes on Session Initialization|: to provide custom views for
 * session initialization (only relevant for browser-based hosted
 * Kui), you can instantiate <Kui/> with these properties (defined in
 * KuiConfiguration), show here with some sample views:
 *
 * <Kui
 *    loading={<div className="kui--hero-text">Hold on...</div>}
 *    reinit={<div className="kui--hero-text">Connection broken...</div>}
 *    loadingError={err => <div className="kui--hero-text">{err.toString()}</div>}
 *    loadingDone={<div>Welcome to Kui</div>}
 * />
 *
 */
export declare class Kui extends React.PureComponent<Props, State> {
    constructor(props: Props);
    private defaultFeatureFlag;
    private defaultLoading;
    private defaultReinit;
    private defaultLoadingDone;
    private defaultLoadingError;
    /**
     * For browser-based clients, this defines the default UI for
     * session initialization.
     *
     */
    private defaultSessionBehavior;
    private onThemeChange;
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    render(): JSX.Element;
}
export default Kui;
