import { Row as KuiRow, Table as KuiTable } from '@kui-shell/core';
import { DataTableHeader, DataTableRow } from 'carbon-components-react';
export interface NamedDataTableRow extends DataTableRow {
    NAME: string;
    rowKey: string;
    justUpdated: boolean;
}
/**
 * Schema-align a Kui header model to one that works with the Carbon
 * DataTable.
 *
 */
export declare function kuiHeader2carbonHeader(header: KuiRow): DataTableHeader[];
/**
 * Schema-align a KuiRow model to one that works with the Carbon
 * DataTable.
 *
 */
export declare function kuiRow2carbonRow(headers: DataTableHeader[], justUpdated?: boolean): (row: KuiRow, ridx: number) => NamedDataTableRow;
/**
 * Align the KuiTable model to something more convenient for Carbon
 * Components.
 *
 */
export default function kui2carbon(response: KuiTable): {
    headers: DataTableHeader[];
    rows: NamedDataTableRow[];
};
