import * as React from 'react';
import { REPL } from '@kui-shell/core';
import Width from './width';
import { BreadcrumbView } from '../../spi/Breadcrumb';
export interface Props {
    kind?: string;
    name?: string;
    namespace?: string;
    breadcrumbs?: BreadcrumbView[];
    repl: REPL;
    fixedWidth: boolean;
    width: Width;
    onClickNamespace?: () => void;
    onMaximize: () => void;
    onRestore: () => void;
    onClose: () => void;
    willScreenshot: () => void;
    back?: {
        enabled: boolean;
        onClick: () => void;
    };
    forward?: {
        enabled?: boolean;
        onClick: () => void;
    };
}
/**
 * TitleBar
 * ---------------------------------
 * | Kind | Namespace    S | M m x |
 * ---------------------------------
 *  S: Screenshot button
 *  M: Maximize/Restore button [!props.fixedWith]
 *  m: Minimize button [!props.fixedWith]
 *  x: Close button
 *
 *  Kind: props.kind
 *  Namespace: props.namespace
 */
export default class Window extends React.PureComponent<Props> {
    private toggleMaximization;
    private toggleClose;
    private screenshotAction;
    private overflowButton;
    private maximizeButton;
    private quitButton;
    /** back button */
    private back;
    /** forward button */
    private forward;
    /** render history navigation UI */
    private history;
    render(): JSX.Element;
}
