/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { v4 as uuid } from 'uuid';
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
/** helpful selectors */
function xtermInput(N) {
    return `${Selectors.OUTPUT_N_PTY(N)} .xterm-helper-textarea`;
}
describe('xterm focus', function () {
    before(Common.before(this));
    after(Common.after(this));
    const tmpFile = `/tmp/kui-${uuid()}`;
    const waitForFocus = (selector, timeout) => {
        return this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            try {
                return yield this.app.client.hasFocus(selector);
            }
            catch (err) {
                console.error(err);
                throw err;
            }
        }), timeout || CLI.waitTimeout);
    };
    it(`should touch ${tmpFile}`, () => CLI.command(`touch ${tmpFile}`, this.app)
        .then(ReplExpect.justOK)
        .catch(Common.oops(this, true)));
    it(`should rm -i ${tmpFile}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`rm -i ${tmpFile}`, this.app);
            // wait for the output to appear
            yield waitForFocus(xtermInput(res.count));
            // type "y" to confirm the rm
            yield this.app.client.keys(`y${Keys.ENTER}`);
            // wait for the command to finish with blank output
            yield ReplExpect.blank(res);
        }
        catch (err) {
            return Common.oops(this, true)(err);
        }
    }));
    it('should now give an 404 error on the removed file', () => CLI.command(`cat ${tmpFile}`, this.app)
        .then(ReplExpect.error(404))
        .catch(Common.oops(this, true)));
});
//# sourceMappingURL=pty-focus.js.map