"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2017-18 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const debug = (0, _debug.default)('plugins/core-support/preload');
debug('loading');

/**
 * This is the module
 *
 */
const registration = () => {
  const asyncs = [];

  if (!(0, _core.isHeadless)()) {
    asyncs.push(Promise.resolve().then(() => require('./lib/cmds/zoom')).then(_ => _.preload()));
  }

  return Promise.all(asyncs);
};

var _default = registration;
exports.default = _default;
debug('finished loading');